/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.persistence.imp;

import com.atomikos.diagnostics.Console;
import com.atomikos.persistence.LogException;
import com.atomikos.persistence.LogStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.ProgressMonitorInputStream;

public class FileLogStream
implements LogStream {
    private String baseUrl_;
    private String baseDir_;
    private String baseName_;
    private FileOutputStream output_;
    private ObjectOutputStream ooutput_;
    private long suffix_;
    private boolean simulateCrash_;
    private Console console_;
    private boolean corrupt_;
    private JFrame frame_;

    public FileLogStream(String string, String string2, Console console) throws IOException {
        this.baseDir_ = string;
        this.baseName_ = string2;
        this.baseUrl_ = this.baseDir_ + this.baseName_;
        this.suffix_ = this.getSuffix();
        this.simulateCrash_ = false;
        this.console_ = console;
        this.corrupt_ = false;
    }

    public void monitor(JFrame jFrame) {
        this.frame_ = jFrame;
    }

    private long extractSuffix(String string) {
        int n = string.lastIndexOf(46);
        int n2 = this.baseName_.length();
        String string2 = string.substring(n2, n);
        return new Long(string2);
    }

    private long getSuffix() throws IOException {
        long l = -1L;
        File file = new File(this.baseDir_);
        String[] stringArray = file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.startsWith(FileLogStream.this.baseName_) && string.endsWith(".log");
            }
        });
        for (int i = 0; i < stringArray.length; ++i) {
            long l2 = this.extractSuffix(stringArray[i]);
            if (l >= 0L && l2 >= l) continue;
            l = l2;
        }
        return l;
    }

    private void closeOutput() throws LogException {
        Stack stack = new Stack();
        try {
            FileDescriptor fileDescriptor;
            if (this.output_ != null && (fileDescriptor = this.output_.getFD()).valid()) {
                this.ooutput_.close();
                if (this.console_ != null) {
                    this.console_.println("Logfile closed: " + this.baseUrl_ + this.suffix_ + ".log");
                }
            }
            this.output_ = null;
            this.ooutput_ = null;
        }
        catch (IOException iOException) {
            stack = new Stack();
            throw new LogException("Error closing previous output", stack);
        }
    }

    void setCrashMode() {
        this.simulateCrash_ = true;
    }

    public long getSize() throws LogException {
        long l = -1L;
        try {
            File file = new File(this.baseUrl_ + this.suffix_ + ".log");
            l = file.length();
        }
        catch (Exception exception) {
            Stack<Exception> stack = new Stack<Exception>();
            stack.push(exception);
            throw new LogException("Error in getting size.", stack);
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Vector recover() throws LogException {
        if (this.suffix_ < 0L) {
            return null;
        }
        if (this.corrupt_) {
            throw new LogException("Instance might be corrupted");
        }
        Stack<Exception> stack = new Stack<Exception>();
        Vector<Object> vector = new Vector<Object>();
        InputStream inputStream = null;
        try {
            try {
                InputStream inputStream2;
                FileInputStream fileInputStream = new FileInputStream(this.baseUrl_ + this.suffix_ + ".log");
                if (this.frame_ != null) {
                    inputStream = inputStream2 = new ProgressMonitorInputStream(this.frame_, "Reading log: " + this.baseName_ + this.suffix_ + ".log", fileInputStream);
                    ((ProgressMonitorInputStream)inputStream2).getProgressMonitor().setMillisToDecideToPopup(100);
                    ((ProgressMonitorInputStream)inputStream2).getProgressMonitor().setMillisToPopup(100);
                } else {
                    inputStream = fileInputStream;
                }
                inputStream2 = new ObjectInputStream(inputStream);
                int n = 0;
                if (this.console_ != null) {
                    this.console_.println("Starting read of logfile " + this.baseUrl_ + this.suffix_ + ".log");
                }
                while (inputStream.available() > 0) {
                    Object object = ((ObjectInputStream)inputStream2).readObject();
                    vector.addElement(object);
                    if (++n % 10 != 0 || this.console_ == null) continue;
                    this.console_.print(".");
                }
                if (this.console_ != null) {
                    this.console_.println("Done read of logfile");
                }
            }
            catch (EOFException eOFException) {
                Object var9_11 = null;
                try {
                    if (inputStream == null) return vector;
                    inputStream.close();
                    return vector;
                }
                catch (IOException iOException) {
                    stack.push(iOException);
                    throw new LogException("Error in recover", stack);
                }
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
                System.err.println(exception.getClass().getName());
                exception.printStackTrace();
                stack.push(exception);
                throw new LogException("Error in recover", stack);
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            try {}
            catch (IOException iOException) {
                stack.push(iOException);
                throw new LogException("Error in recover", stack);
            }
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            stack.push(iOException);
            throw new LogException("Error in recover", stack);
        }
        if (inputStream == null) return vector;
        inputStream.close();
        return vector;
    }

    public synchronized void writeCheckpoint(Enumeration enumeration) throws LogException {
        Stack<Exception> stack = new Stack<Exception>();
        this.closeOutput();
        ++this.suffix_;
        if (this.suffix_ < 0L) {
            throw new RuntimeException("Log suffix overflow");
        }
        try {
            Object object;
            this.output_ = new FileOutputStream(this.baseUrl_ + this.suffix_ + ".log");
            this.ooutput_ = new ObjectOutputStream(this.output_);
            while (enumeration != null && enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                this.ooutput_.writeObject(object);
            }
            this.ooutput_.flush();
            this.output_.flush();
            this.output_.getFD().sync();
            object = new File(this.baseUrl_ + (this.suffix_ - 1L) + ".log");
            if (((File)object).exists() && (this.simulateCrash_ || !((File)object).delete())) {
                this.corrupt_ = true;
                throw new LogException("Old file could not be deleted");
            }
        }
        catch (Exception exception) {
            stack.push(exception);
            throw new LogException("Error during checkpointing", stack);
        }
    }

    public synchronized void flushObject(Object object) throws LogException {
        if (this.ooutput_ == null) {
            throw new LogException("Not Initialized or already closed");
        }
        try {
            this.ooutput_.writeObject(object);
            this.output_.flush();
            this.ooutput_.flush();
            this.output_.getFD().sync();
        }
        catch (IOException iOException) {
            Stack stack = new Stack();
            throw new LogException(iOException.getMessage(), stack);
        }
    }

    public synchronized void close() throws LogException {
        this.closeOutput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

