/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.system;

import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.Propagation;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SubTxCode;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.icatch.system.Waiter;

public class SubTxThread
extends Thread {
    private SubTxCode myCode;
    private Waiter myWaiter;
    private Exception myException;
    private CompositeTransaction parent = Configuration.getCompositeTransactionManager().getCompositeTransaction();
    private Propagation propagation;
    private HeuristicMessage msg;

    public SubTxThread(Waiter waiter, SubTxCode subTxCode, HeuristicMessage heuristicMessage) throws SysException {
        this.msg = heuristicMessage;
        try {
            this.propagation = Configuration.getExportingTransactionManager().getPropagation();
        }
        catch (RollbackException rollbackException) {
            throw new SysException("Transaction already rolled back");
        }
        this.myWaiter = waiter;
        this.myWaiter.incActives();
        this.myCode = subTxCode;
        this.myException = null;
    }

    public Exception getException() {
        return this.myException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        CompositeTransaction compositeTransaction = null;
        try {
            try {
                compositeTransaction = Configuration.getImportingTransactionManager().importTransaction(this.propagation, true, false);
                compositeTransaction.getTransactionControl().setTag(this.msg);
                if (this.propagation.isSerial()) {
                    this.myWaiter.getToken();
                }
                this.myCode.exec();
                compositeTransaction.getTransactionControl().getTerminator().commit();
            }
            catch (Exception exception) {
                this.myWaiter.incAbortCount();
                this.myException = exception;
                compositeTransaction.getTransactionControl().getTerminator().rollback();
                Object var4_3 = null;
                if (this.propagation.isSerial()) {
                    this.myWaiter.giveToken();
                }
                this.myWaiter.decActives();
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.propagation.isSerial()) {
                this.myWaiter.giveToken();
            }
            this.myWaiter.decActives();
            throw throwable;
        }
        if (this.propagation.isSerial()) {
            this.myWaiter.giveToken();
        }
        this.myWaiter.decActives();
    }
}

