/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.StringHeuristicMessage;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.imp.Reply;
import com.atomikos.icatch.imp.Result;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;

class TerminationResult
extends Result {
    protected boolean analyzed_ = false;
    protected Hashtable heuristicparticipants_ = new Hashtable();
    protected Hashtable possiblyIndoubts_ = new Hashtable();

    public TerminationResult(int n) {
        super(n);
    }

    public Hashtable getHeuristicParticipants() throws IllegalStateException, InterruptedException {
        this.analyze();
        return this.heuristicparticipants_;
    }

    public Hashtable getPossiblyIndoubts() throws IllegalStateException, InterruptedException {
        this.analyze();
        return this.possiblyIndoubts_;
    }

    protected synchronized void analyze() throws IllegalStateException, InterruptedException {
        if (this.analyzed_) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = true;
        boolean bl6 = false;
        Stack stack = this.getReplies();
        Enumeration enumeration = stack.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            Reply reply = (Reply)enumeration.nextElement();
            if (reply.hasFailed()) {
                Throwable throwable;
                bl5 = false;
                object = reply.getException();
                if (object instanceof RollbackException) {
                    bl6 = true;
                    continue;
                }
                if (object instanceof HeurMixedException) {
                    bl = true;
                    throwable = (HeurMixedException)((Object)object);
                    this.addErrorMessages(throwable.getHeuristicMessages());
                    this.heuristicparticipants_.put(reply.getParticipant(), TxState.HEUR_MIXED);
                    continue;
                }
                if (object instanceof HeurCommitException) {
                    bl3 = true;
                    throwable = (HeurCommitException)((Object)object);
                    this.addErrorMessages(throwable.getHeuristicMessages());
                    bl = bl || bl2 || bl4;
                    this.heuristicparticipants_.put(reply.getParticipant(), TxState.HEUR_COMMITTED);
                    continue;
                }
                if (object instanceof HeurRollbackException) {
                    bl2 = true;
                    bl = bl || bl3 || bl4;
                    throwable = (HeurRollbackException)((Object)object);
                    this.addErrorMessages(throwable.getHeuristicMessages());
                    this.heuristicparticipants_.put(reply.getParticipant(), TxState.HEUR_ABORTED);
                    continue;
                }
                bl4 = true;
                bl = bl || bl2 || bl3;
                throwable = new StringHeuristicMessage("No commit ACK from participant " + reply.getParticipant());
                this.errmsgvector_.addElement(throwable);
                this.heuristicparticipants_.put(reply.getParticipant(), TxState.HEUR_HAZARD);
                this.possiblyIndoubts_.put(reply.getParticipant(), TxState.HEUR_HAZARD);
                continue;
            }
            object = (HeuristicMessage[])reply.getResponse();
            if (object == null) continue;
            this.addMessages((HeuristicMessage[])object);
        }
        if (bl6) {
            this.result_ = 6;
        } else if (bl || bl2 && this.heuristicparticipants_.size() != stack.size() || bl3 && this.heuristicparticipants_.size() != stack.size()) {
            this.result_ = 2;
        } else if (bl4) {
            this.result_ = 1;
        } else if (bl2) {
            this.result_ = 3;
        } else if (bl3) {
            this.result_ = 4;
        } else if (bl5) {
            this.result_ = 0;
        }
        this.analyzed_ = true;
    }
}

