/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TransactionService;
import com.atomikos.icatch.imp.CoordinatorImp;
import com.atomikos.icatch.system.Configuration;
import java.util.Dictionary;

public class SubTransactionCoordinatorParticipant
implements Participant {
    private static final long serialVersionUID = -321213151844934630L;
    private transient Participant subordinateCoordinator;
    private String subordinateId;
    private HeuristicMessage[] msgs;
    private boolean prepareCalled;

    public SubTransactionCoordinatorParticipant(CoordinatorImp coordinatorImp) {
        this.subordinateCoordinator = coordinatorImp;
        this.subordinateId = coordinatorImp.getCoordinatorId();
        this.msgs = coordinatorImp.getHeuristicMessages();
        this.prepareCalled = false;
    }

    public boolean recover() throws SysException {
        TransactionService transactionService = Configuration.getTransactionService();
        this.subordinateCoordinator = transactionService.getParticipant(this.subordinateId);
        return this.subordinateCoordinator != null;
    }

    public String getURI() {
        return this.subordinateId;
    }

    public void setCascadeList(Dictionary dictionary) throws SysException {
        this.subordinateCoordinator.setCascadeList(dictionary);
    }

    public void setGlobalSiblingCount(int n) {
        this.subordinateCoordinator.setGlobalSiblingCount(n);
    }

    public int prepare() throws RollbackException, HeurHazardException, HeurMixedException, SysException {
        this.prepareCalled = true;
        return this.subordinateCoordinator.prepare();
    }

    public HeuristicMessage[] commit(boolean bl) throws HeurRollbackException, HeurHazardException, HeurMixedException, RollbackException, SysException {
        HeuristicMessage[] heuristicMessageArray = this.getHeuristicMessages();
        if (this.subordinateCoordinator == null) {
            if (this.prepareCalled) {
                throw new HeurHazardException(heuristicMessageArray);
            }
            throw new RollbackException();
        }
        this.subordinateCoordinator.commit(bl);
        return heuristicMessageArray;
    }

    public HeuristicMessage[] rollback() throws HeurCommitException, HeurMixedException, HeurHazardException, SysException {
        HeuristicMessage[] heuristicMessageArray = this.getHeuristicMessages();
        if (this.subordinateCoordinator != null) {
            this.subordinateCoordinator.rollback();
        } else if (this.prepareCalled) {
            throw new HeurHazardException(heuristicMessageArray);
        }
        return heuristicMessageArray;
    }

    public void forget() {
        if (this.subordinateCoordinator != null) {
            this.subordinateCoordinator.forget();
        }
    }

    public HeuristicMessage[] getHeuristicMessages() {
        if (this.subordinateCoordinator != null) {
            this.msgs = this.subordinateCoordinator.getHeuristicMessages();
        }
        return this.msgs;
    }
}

