/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.SubTxAwareParticipant;
import com.atomikos.icatch.system.Configuration;

public class ResumePreviousTransactionSubTxAwareParticipant
implements SubTxAwareParticipant {
    private CompositeTransaction previous;

    public ResumePreviousTransactionSubTxAwareParticipant(CompositeTransaction compositeTransaction) {
        if (compositeTransaction == null) {
            throw new IllegalArgumentException("Previous transaction is null?");
        }
        this.previous = compositeTransaction;
    }

    private void resume() {
        CompositeTransactionManager compositeTransactionManager = Configuration.getCompositeTransactionManager();
        if (compositeTransactionManager == null) {
            Configuration.logWarning("ResumePreviousTransactionSubTxAwareParticipant: no transaction manager found?");
        } else {
            try {
                compositeTransactionManager.resume(this.previous);
            }
            catch (Exception exception) {
                Configuration.logWarning("ResumePreviousTransactionSubTxAwareParticipant: could not resume previous transaction", exception);
            }
        }
    }

    public void committed(CompositeTransaction compositeTransaction) {
        this.resume();
    }

    public void rolledback(CompositeTransaction compositeTransaction) {
        this.resume();
    }
}

