/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.imp.PropagationMessage;
import com.atomikos.icatch.imp.thread.TaskManager;
import com.atomikos.icatch.system.Configuration;

class Propagator {
    static long RETRY_INTERVAL = 10000L;
    private boolean threaded_ = true;

    Propagator(boolean bl) {
        this.threaded_ = bl;
    }

    public synchronized void submitPropagationMessage(PropagationMessage propagationMessage) {
        PropagatorThread propagatorThread = new PropagatorThread(propagationMessage);
        if (this.threaded_) {
            TaskManager.getInstance().executeTask(propagatorThread);
        } else {
            propagatorThread.run();
        }
    }

    private static class PropagatorThread
    implements Runnable {
        private PropagationMessage msg;

        PropagatorThread(PropagationMessage propagationMessage) {
            this.msg = propagationMessage;
        }

        public void run() {
            try {
                boolean bl = true;
                do {
                    if (!(bl = this.msg.submit())) continue;
                    Thread.sleep(RETRY_INTERVAL);
                    Configuration.logDebug("Propagator: retrying message: " + this.msg);
                } while (bl);
            }
            catch (Exception exception) {
                Configuration.logWarning("ERROR in propagator: " + exception.getMessage() + (this.msg != null ? " while sending message: " + this.msg : ""), exception);
            }
        }
    }
}

