/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.diagnostics.Console;
import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.imp.CommitMessage;
import com.atomikos.icatch.imp.CoordinatorImp;
import com.atomikos.icatch.imp.ForgetMessage;
import com.atomikos.icatch.imp.ForgetResult;
import com.atomikos.icatch.imp.HeurAbortedStateHandler;
import com.atomikos.icatch.imp.HeurCommittedStateHandler;
import com.atomikos.icatch.imp.HeurHazardStateHandler;
import com.atomikos.icatch.imp.HeurMixedStateHandler;
import com.atomikos.icatch.imp.PropagationMessage;
import com.atomikos.icatch.imp.Propagator;
import com.atomikos.icatch.imp.RollbackMessage;
import com.atomikos.icatch.imp.TerminatedStateHandler;
import com.atomikos.icatch.imp.TerminationResult;
import java.io.IOException;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

abstract class CoordinatorStateHandler
implements Serializable,
Cloneable {
    private static final int THREADS = 1;
    private transient CoordinatorImp coordinator_;
    private Hashtable readOnlyTable_;
    private transient Propagator propagator_;
    private transient Stack replayStack_;
    private Boolean committed_;
    private transient Dictionary cascadeList_;
    private Hashtable heuristicMap_;

    protected CoordinatorStateHandler(CoordinatorImp coordinatorImp) {
        this.coordinator_ = coordinatorImp;
        this.replayStack_ = new Stack();
        this.readOnlyTable_ = new Hashtable();
        this.committed_ = null;
        this.heuristicMap_ = new Hashtable();
        this.heuristicMap_.put(TxState.HEUR_HAZARD, new Stack());
        this.heuristicMap_.put(TxState.HEUR_MIXED, new Stack());
        this.heuristicMap_.put(TxState.HEUR_ABORTED, new Stack());
        this.heuristicMap_.put(TxState.HEUR_COMMITTED, new Stack());
        this.heuristicMap_.put(TxState.TERMINATED, new Stack());
    }

    protected CoordinatorStateHandler(CoordinatorStateHandler coordinatorStateHandler) {
        this.coordinator_ = coordinatorStateHandler.coordinator_;
        this.propagator_ = coordinatorStateHandler.propagator_;
        this.replayStack_ = coordinatorStateHandler.replayStack_;
        this.readOnlyTable_ = coordinatorStateHandler.readOnlyTable_;
        this.committed_ = coordinatorStateHandler.committed_;
        this.cascadeList_ = coordinatorStateHandler.cascadeList_;
        this.heuristicMap_ = coordinatorStateHandler.heuristicMap_;
    }

    void setCommitted() {
        this.committed_ = new Boolean(true);
    }

    public Object clone() {
        CoordinatorStateHandler coordinatorStateHandler = null;
        try {
            coordinatorStateHandler = (CoordinatorStateHandler)super.clone();
            coordinatorStateHandler.readOnlyTable_ = (Hashtable)this.readOnlyTable_.clone();
            coordinatorStateHandler.heuristicMap_ = new Hashtable();
            Stack stack = (Stack)this.heuristicMap_.get(TxState.HEUR_HAZARD);
            Stack stack2 = (Stack)this.heuristicMap_.get(TxState.HEUR_MIXED);
            Stack stack3 = (Stack)this.heuristicMap_.get(TxState.HEUR_COMMITTED);
            Stack stack4 = (Stack)this.heuristicMap_.get(TxState.HEUR_ABORTED);
            Stack stack5 = (Stack)this.heuristicMap_.get(TxState.TERMINATED);
            coordinatorStateHandler.heuristicMap_.put(TxState.HEUR_HAZARD, stack.clone());
            coordinatorStateHandler.heuristicMap_.put(TxState.HEUR_MIXED, stack2.clone());
            coordinatorStateHandler.heuristicMap_.put(TxState.HEUR_COMMITTED, stack3.clone());
            coordinatorStateHandler.heuristicMap_.put(TxState.HEUR_ABORTED, stack4.clone());
            coordinatorStateHandler.heuristicMap_.put(TxState.TERMINATED, stack5.clone());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("CoordinatorStateHandler: clone failure :" + cloneNotSupportedException.getMessage());
        }
        return coordinatorStateHandler;
    }

    protected void addToHeuristicMap(Participant participant, Object object) {
        Stack stack = (Stack)this.heuristicMap_.get(object);
        stack.push(participant);
    }

    protected void addToHeuristicMap(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Participant participant = (Participant)enumeration.nextElement();
            Object v = hashtable.get(participant);
            this.addToHeuristicMap(participant, v);
        }
    }

    protected HeuristicMessage[] getHeuristicMessages(Object object) {
        Participant participant;
        Vector<HeuristicMessage> vector = new Vector<HeuristicMessage>();
        Stack stack = (Stack)this.heuristicMap_.get(object);
        if (stack == null) {
            throw new RuntimeException("Error: getHeuristicMessages for non-mapped heuristic state: " + object);
        }
        Enumeration enumeration = stack.elements();
        while (enumeration.hasMoreElements()) {
            participant = (Participant)enumeration.nextElement();
            HeuristicMessage[] heuristicMessageArray = participant.getHeuristicMessages();
            if (heuristicMessageArray == null) continue;
            for (int i = 0; i < heuristicMessageArray.length; ++i) {
                vector.addElement(heuristicMessageArray[i]);
            }
        }
        participant = new Participant[]{};
        return (HeuristicMessage[])vector.toArray((T[])participant);
    }

    protected HeuristicMessage[] getHeuristicMessages() {
        Participant participant;
        Vector<HeuristicMessage> vector = new Vector<HeuristicMessage>();
        Enumeration enumeration = this.coordinator_.getParticipants().keys();
        while (enumeration.hasMoreElements()) {
            participant = (Participant)enumeration.nextElement();
            HeuristicMessage[] heuristicMessageArray = participant.getHeuristicMessages();
            if (heuristicMessageArray == null) continue;
            for (int i = 0; i < heuristicMessageArray.length; ++i) {
                vector.addElement(heuristicMessageArray[i]);
            }
        }
        participant = new Participant[]{};
        return (HeuristicMessage[])vector.toArray((T[])participant);
    }

    protected CoordinatorImp getCoordinator() {
        return this.coordinator_;
    }

    protected long getRollbackTicks() {
        return 0L;
    }

    protected Stack getReplayStack() {
        return this.replayStack_;
    }

    protected Hashtable getReadOnlyTable() {
        return this.readOnlyTable_;
    }

    protected Dictionary getCascadeList() {
        return this.cascadeList_;
    }

    protected Propagator getPropagator() {
        return this.propagator_;
    }

    protected Boolean getCommitted() {
        return this.committed_;
    }

    protected boolean isCommitted() {
        if (this.committed_ == null) {
            return false;
        }
        return this.committed_;
    }

    protected void printMsg(String string) {
        try {
            Console console = this.coordinator_.getConsole();
            if (console != null) {
                console.println(string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void printMsg(String string, int n) {
        Console console = this.coordinator_.getConsole();
        if (console != null) {
            try {
                console.println(string, n);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void setReadOnlyTable(Hashtable hashtable) {
        this.readOnlyTable_ = hashtable;
    }

    protected void activate() {
        boolean bl;
        boolean bl2 = bl = !this.coordinator_.prefersSingleThreaded2PC();
        if (this.propagator_ == null) {
            this.propagator_ = new Propagator(bl);
        }
    }

    protected void recover(CoordinatorImp coordinatorImp) {
        this.coordinator_ = coordinatorImp;
        this.replayStack_ = new Stack();
    }

    protected void dispose() {
        this.propagator_ = null;
    }

    protected Boolean replayCompletion(Participant participant) throws IllegalStateException {
        if (!this.replayStack_.contains(participant)) {
            this.replayStack_.push(participant);
        }
        return this.committed_;
    }

    protected void setCascadeList(Dictionary dictionary) {
        this.cascadeList_ = dictionary;
    }

    protected abstract void onTimeout();

    abstract Object getState();

    abstract void setGlobalSiblingCount(int var1);

    protected abstract int prepare() throws RollbackException, IllegalStateException, HeurHazardException, HeurMixedException, SysException;

    protected abstract HeuristicMessage[] commit(boolean var1) throws HeurRollbackException, HeurMixedException, HeurHazardException, IllegalStateException, RollbackException, SysException;

    protected abstract HeuristicMessage[] rollback() throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException;

    protected HeuristicMessage[] commit(boolean bl, boolean bl2) throws HeurRollbackException, HeurMixedException, HeurHazardException, IllegalStateException, RollbackException, SysException {
        Stack<Exception> stack = new Stack<Exception>();
        CoordinatorStateHandler coordinatorStateHandler = null;
        try {
            Serializable serializable;
            Object object;
            Hashtable hashtable = this.coordinator_.getParticipants();
            int n = hashtable.size() - this.readOnlyTable_.size();
            TerminationResult terminationResult = new TerminationResult(n);
            this.coordinator_.setState(TxState.COMMITTING);
            this.committed_ = new Boolean(true);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Participant participant = (Participant)enumeration.nextElement();
                if (this.readOnlyTable_.containsKey(participant)) continue;
                object = new CommitMessage(participant, terminationResult, bl2);
                if (bl2 && this.cascadeList_ != null) {
                    serializable = (Integer)this.cascadeList_.get(participant);
                    if (serializable != null) {
                        participant.setGlobalSiblingCount(((Integer)serializable).intValue());
                    }
                    participant.setCascadeList(this.cascadeList_);
                }
                this.propagator_.submitPropagationMessage((PropagationMessage)object);
            }
            terminationResult.waitForReplies();
            int n2 = terminationResult.getResult();
            if (n2 != 0) {
                if (n2 == 2) {
                    object = terminationResult.getPossiblyIndoubts();
                    serializable = terminationResult.getHeuristicParticipants();
                    this.addToHeuristicMap((Hashtable)serializable);
                    enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        Participant participant = (Participant)enumeration.nextElement();
                        if (((Hashtable)serializable).containsKey(participant)) continue;
                        this.addToHeuristicMap(participant, TxState.TERMINATED);
                    }
                    coordinatorStateHandler = new HeurMixedStateHandler(this, (Hashtable)object);
                    this.coordinator_.setStateHandler(coordinatorStateHandler);
                    throw new HeurMixedException(this.getHeuristicMessages());
                }
                if (n2 == 6) {
                    coordinatorStateHandler = new TerminatedStateHandler(this);
                    this.coordinator_.setStateHandler(coordinatorStateHandler);
                    throw new RollbackException("Rolled back already.");
                }
                if (n2 == 3) {
                    coordinatorStateHandler = new HeurAbortedStateHandler(this);
                    this.coordinator_.setStateHandler(coordinatorStateHandler);
                    throw new HeurRollbackException(this.getHeuristicMessages());
                }
                if (n2 == 1) {
                    object = terminationResult.getPossiblyIndoubts();
                    serializable = terminationResult.getHeuristicParticipants();
                    this.addToHeuristicMap((Hashtable)serializable);
                    enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        Participant participant = (Participant)enumeration.nextElement();
                        if (((Hashtable)serializable).containsKey(participant)) continue;
                        this.addToHeuristicMap(participant, TxState.TERMINATED);
                    }
                    coordinatorStateHandler = new HeurHazardStateHandler(this, (Hashtable)object);
                    this.coordinator_.setStateHandler(coordinatorStateHandler);
                    throw new HeurHazardException(this.getHeuristicMessages());
                }
            } else {
                coordinatorStateHandler = bl ? new HeurCommittedStateHandler(this) : new TerminatedStateHandler(this);
                this.coordinator_.setStateHandler(coordinatorStateHandler);
            }
        }
        catch (RuntimeException runtimeException) {
            stack.push(runtimeException);
            throw new SysException("Error in commit: " + runtimeException.getMessage(), stack);
        }
        catch (InterruptedException interruptedException) {
            stack.push(interruptedException);
            throw new SysException("Error in commit" + interruptedException.getMessage(), stack);
        }
        return this.getHeuristicMessages();
    }

    protected HeuristicMessage[] rollback(boolean bl, boolean bl2) throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException {
        Stack<Exception> stack = new Stack<Exception>();
        CoordinatorStateHandler coordinatorStateHandler = null;
        try {
            Object object;
            this.coordinator_.setState(TxState.ABORTING);
            this.committed_ = new Boolean(false);
            Hashtable hashtable = this.coordinator_.getParticipants();
            int n = hashtable.size() - this.readOnlyTable_.size();
            TerminationResult terminationResult = new TerminationResult(n);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Participant participant = (Participant)enumeration.nextElement();
                if (this.readOnlyTable_.containsKey(participant)) continue;
                object = new RollbackMessage(participant, terminationResult, bl);
                this.propagator_.submitPropagationMessage((PropagationMessage)object);
            }
            terminationResult.waitForReplies();
            int n2 = terminationResult.getResult();
            if (bl && n2 != 0) {
                if (n2 == 2) {
                    object = terminationResult.getPossiblyIndoubts();
                    Hashtable hashtable2 = terminationResult.getHeuristicParticipants();
                    this.addToHeuristicMap(hashtable2);
                    enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        Participant participant = (Participant)enumeration.nextElement();
                        if (hashtable2.containsKey(participant)) continue;
                        this.addToHeuristicMap(participant, TxState.TERMINATED);
                    }
                    coordinatorStateHandler = new HeurMixedStateHandler(this, (Hashtable)object);
                    this.coordinator_.setStateHandler(coordinatorStateHandler);
                    throw new HeurMixedException(this.getHeuristicMessages());
                }
                if (n2 == 4) {
                    coordinatorStateHandler = new HeurCommittedStateHandler(this);
                    this.coordinator_.setStateHandler(coordinatorStateHandler);
                    throw new HeurCommitException(this.getHeuristicMessages());
                }
                if (n2 == 1) {
                    object = terminationResult.getPossiblyIndoubts();
                    Hashtable hashtable3 = terminationResult.getHeuristicParticipants();
                    this.addToHeuristicMap(hashtable3);
                    enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        Participant participant = (Participant)enumeration.nextElement();
                        if (hashtable3.containsKey(participant)) continue;
                        this.addToHeuristicMap(participant, TxState.TERMINATED);
                    }
                    coordinatorStateHandler = new HeurHazardStateHandler(this, (Hashtable)object);
                    this.coordinator_.setStateHandler(coordinatorStateHandler);
                    throw new HeurHazardException(this.getHeuristicMessages());
                }
            } else {
                coordinatorStateHandler = bl2 ? new HeurAbortedStateHandler(this) : new TerminatedStateHandler(this);
                this.coordinator_.setStateHandler(coordinatorStateHandler);
            }
        }
        catch (RuntimeException runtimeException) {
            stack.push(runtimeException);
            throw new SysException("Error in rollback: " + runtimeException.getMessage(), stack);
        }
        catch (InterruptedException interruptedException) {
            stack.push(interruptedException);
            throw new SysException("Error in rollback: " + interruptedException.getMessage(), stack);
        }
        return this.getHeuristicMessages();
    }

    protected void forget() {
        TerminatedStateHandler terminatedStateHandler = null;
        Hashtable hashtable = this.coordinator_.getParticipants();
        int n = hashtable.size() - this.readOnlyTable_.size();
        Enumeration enumeration = hashtable.keys();
        ForgetResult forgetResult = new ForgetResult(n);
        while (enumeration.hasMoreElements()) {
            Participant participant = (Participant)enumeration.nextElement();
            if (this.readOnlyTable_.containsKey(participant)) continue;
            ForgetMessage forgetMessage = new ForgetMessage(participant, forgetResult);
            this.propagator_.submitPropagationMessage(forgetMessage);
        }
        try {
            forgetResult.waitForReplies();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        terminatedStateHandler = new TerminatedStateHandler(this);
        this.coordinator_.setStateHandler(terminatedStateHandler);
    }
}

