/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.diagnostics.Console;
import com.atomikos.finitestates.FSM;
import com.atomikos.finitestates.FSMEnterEvent;
import com.atomikos.finitestates.FSMEnterListener;
import com.atomikos.finitestates.FSMImp;
import com.atomikos.finitestates.FSMPreEnterListener;
import com.atomikos.finitestates.Stateful;
import com.atomikos.finitestates.TransitionTable;
import com.atomikos.icatch.CompositeCoordinator;
import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RecoveryCoordinator;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.Synchronization;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.imp.ActiveStateHandler;
import com.atomikos.icatch.imp.CoordinatorLogImage;
import com.atomikos.icatch.imp.CoordinatorStateHandler;
import com.atomikos.icatch.imp.HeurHazardStateHandler;
import com.atomikos.icatch.imp.ReadOnlyParticipant;
import com.atomikos.icatch.imp.SynchToFSM;
import com.atomikos.icatch.imp.TransactionTransitionTable;
import com.atomikos.icatch.imp.thread.TaskManager;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.persistence.ObjectImage;
import com.atomikos.persistence.StateRecoverable;
import com.atomikos.timing.AlarmTimer;
import com.atomikos.timing.AlarmTimerListener;
import com.atomikos.timing.PooledAlarmTimer;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CoordinatorImp
implements CompositeCoordinator,
Participant,
RecoveryCoordinator,
StateRecoverable,
AlarmTimerListener,
Stateful,
FSMPreEnterListener {
    static long DEFAULT_TIMEOUT = 150L;
    private static final int MAX_INDOUBT_TICKS = 30;
    private static final int MAX_ROLLBACK_TICKS = 30;
    private Console console_ = null;
    private int localSiblingCount_ = 0;
    private AlarmTimer timer_ = null;
    private boolean checkSiblings_ = true;
    private long maxIndoubtTicks_ = 30L;
    private long maxRollbackTicks_ = 30L;
    private String root_ = null;
    private FSM fsm_ = null;
    private boolean recoverableWhileActive_;
    private boolean heuristicCommit_ = true;
    private Hashtable participants_ = new Hashtable();
    private RecoveryCoordinator coordinator_ = null;
    private Vector tags_ = new Vector();
    private CoordinatorStateHandler stateHandler_;
    private boolean single_threaded_2pc_;

    protected CoordinatorImp(String string, boolean bl, Console console, boolean bl2) {
        this.root_ = string;
        this.fsm_ = new FSMImp((Object)this, (TransitionTable)new TransactionTransitionTable(), (Object)TxState.ACTIVE);
        this.heuristicCommit_ = bl;
        this.console_ = console;
        this.setStateHandler(new ActiveStateHandler(this));
        this.startThreads(DEFAULT_TIMEOUT, console);
        this.checkSiblings_ = bl2;
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.TERMINATED);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.HEUR_COMMITTED);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.HEUR_ABORTED);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.HEUR_MIXED);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.HEUR_HAZARD);
        this.single_threaded_2pc_ = false;
    }

    protected CoordinatorImp(String string, RecoveryCoordinator recoveryCoordinator, Console console, boolean bl, long l, boolean bl2, boolean bl3) {
        this.root_ = string;
        this.single_threaded_2pc_ = bl3;
        this.fsm_ = new FSMImp((Object)this, (TransitionTable)new TransactionTransitionTable(), (Object)TxState.ACTIVE);
        this.heuristicCommit_ = bl;
        this.console_ = console;
        this.recoverableWhileActive_ = false;
        this.coordinator_ = recoveryCoordinator;
        if (l > DEFAULT_TIMEOUT) {
            this.maxRollbackTicks_ = this.maxIndoubtTicks_ = l / DEFAULT_TIMEOUT;
        }
        this.setStateHandler(new ActiveStateHandler(this));
        this.startThreads(DEFAULT_TIMEOUT, console);
        this.checkSiblings_ = bl2;
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.TERMINATED);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.HEUR_COMMITTED);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.HEUR_ABORTED);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.HEUR_MIXED);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.HEUR_HAZARD);
    }

    public CoordinatorImp(String string, RecoveryCoordinator recoveryCoordinator, Console console, boolean bl, boolean bl2) {
        this(string, recoveryCoordinator, console, bl, DEFAULT_TIMEOUT, bl2, false);
    }

    public CoordinatorImp() {
        this.fsm_ = new FSMImp((Object)this, (TransitionTable)new TransactionTransitionTable(), (Object)TxState.ACTIVE);
        this.heuristicCommit_ = false;
        this.checkSiblings_ = true;
        this.recoverableWhileActive_ = false;
        this.single_threaded_2pc_ = false;
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.TERMINATED);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.HEUR_COMMITTED);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.HEUR_ABORTED);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.HEUR_MIXED);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.HEUR_HAZARD);
    }

    private void printMsg(String string) {
        if (this.console_ != null) {
            try {
                this.console_.println(string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void printMsg(String string, int n) {
        if (this.console_ != null) {
            try {
                this.console_.println(string, n);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    boolean prefersSingleThreaded2PC() {
        return this.single_threaded_2pc_;
    }

    void setCommitted() {
        this.stateHandler_.setCommitted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTag(HeuristicMessage heuristicMessage) {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            if (heuristicMessage != null) {
                this.tags_.addElement(heuristicMessage);
            }
        }
    }

    void setStateHandler(CoordinatorStateHandler coordinatorStateHandler) {
        Object object = coordinatorStateHandler.getState();
        this.stateHandler_ = coordinatorStateHandler;
        this.setState(object);
    }

    RecoveryCoordinator getSuperiorRecoveryCoordinator() {
        return this.coordinator_;
    }

    Hashtable getParticipants() {
        return this.participants_;
    }

    Console getConsole() {
        return this.console_;
    }

    boolean prefersHeuristicCommit() {
        return this.heuristicCommit_;
    }

    int getLocalSiblingCount() {
        return this.localSiblingCount_;
    }

    long getMaxIndoubtTicks() {
        return this.maxIndoubtTicks_;
    }

    long getMaxRollbackTicks() {
        return this.maxRollbackTicks_;
    }

    boolean checkSiblings() {
        return this.checkSiblings_;
    }

    public Boolean isRecoverableWhileActive() {
        return new Boolean(this.recoverableWhileActive_);
    }

    public HeuristicMessage[] getHeuristicMessages(Object object) {
        return this.stateHandler_.getHeuristicMessages(object);
    }

    public boolean isCommitted() {
        return this.stateHandler_.isCommitted();
    }

    public HeuristicMessage[] getHeuristicMessages() {
        return this.stateHandler_.getHeuristicMessages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeuristicMessage[] getTags() {
        HeuristicMessage[] heuristicMessageArray = null;
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            heuristicMessageArray = new HeuristicMessage[this.tags_.size()];
            for (int i = 0; i < heuristicMessageArray.length; ++i) {
                heuristicMessageArray[i] = (HeuristicMessage)this.tags_.elementAt(i);
            }
        }
        return heuristicMessageArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startThreads(long l, Console console) {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            if (this.timer_ == null) {
                this.stateHandler_.activate();
                this.timer_ = new PooledAlarmTimer(l);
                this.timer_.addAlarmTimerListener((AlarmTimerListener)this);
                this.submitTimer(this.timer_);
            }
        }
    }

    private void submitTimer(AlarmTimer alarmTimer) {
        TaskManager.getInstance().executeTask((Runnable)alarmTimer);
    }

    protected long getTimeOut() {
        return (this.maxRollbackTicks_ - this.stateHandler_.getRollbackTicks()) * DEFAULT_TIMEOUT;
    }

    void setState(Object object) throws IllegalStateException {
        Configuration.logDebug("Coordinator " + this.getCoordinatorId() + " entering state: " + object.toString());
        this.fsm_.setState(object);
        this.printMsg("Coordinator " + this.getCoordinatorId() + " entered state: " + object.toString(), 3);
    }

    public Object getState() {
        return this.fsm_.getState();
    }

    public void addFSMEnterListener(FSMEnterListener fSMEnterListener, Object object) {
        this.fsm_.addFSMEnterListener(fSMEnterListener, object);
    }

    public void addFSMPreEnterListener(FSMPreEnterListener fSMPreEnterListener, Object object) {
        this.fsm_.addFSMPreEnterListener(fSMPreEnterListener, object);
    }

    public RecoveryCoordinator getRecoveryCoordinator() {
        return this;
    }

    public Participant getParticipant() throws UnsupportedOperationException {
        return this;
    }

    public String getCoordinatorId() {
        return this.root_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoveryCoordinator addParticipant(Participant participant) throws SysException, IllegalStateException, RollbackException {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            if (!this.getState().equals(TxState.ACTIVE)) {
                throw new IllegalStateException("Wrong state for addParticipant: " + this.getState().toString() + " in coordinator " + this.getCoordinatorId());
            }
            if (!this.participants_.containsKey(participant)) {
                this.participants_.put(participant, new Integer(0));
            }
            this.setState(TxState.ACTIVE);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incLocalSiblingCount() {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            ++this.localSiblingCount_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerSynchronization(Synchronization synchronization) throws RollbackException, IllegalStateException, UnsupportedOperationException, SysException {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            if (!this.getState().equals(TxState.ACTIVE)) {
                throw new IllegalStateException("wrong state: " + this.getState());
            }
            ReadOnlyParticipant readOnlyParticipant = new ReadOnlyParticipant(this);
            this.addParticipant(readOnlyParticipant);
            SynchToFSM synchToFSM = new SynchToFSM(synchronization);
            this.addFSMEnterListener(synchToFSM, TxState.COMMITTING);
            this.addFSMEnterListener(synchToFSM, TxState.ABORTING);
            this.addFSMEnterListener(synchToFSM, TxState.TERMINATED);
            this.addFSMEnterListener(synchToFSM, TxState.HEUR_MIXED);
            this.addFSMEnterListener(synchToFSM, TxState.HEUR_ABORTED);
            this.addFSMEnterListener(synchToFSM, TxState.HEUR_HAZARD);
            this.addFSMEnterListener(synchToFSM, TxState.HEUR_COMMITTED);
        }
    }

    public void preEnter(FSMEnterEvent fSMEnterEvent) throws IllegalStateException {
        Object object = fSMEnterEvent.getState();
        if (object.equals(TxState.TERMINATED) || object.equals(TxState.HEUR_ABORTED) || object.equals(TxState.HEUR_COMMITTED) || object.equals(TxState.HEUR_HAZARD) || object.equals(TxState.HEUR_MIXED)) {
            if (!object.equals(TxState.TERMINATED)) {
                this.printMsg("Local heuristic termination of coordinator " + this.root_ + " with state " + this.getState());
            } else {
                this.dispose();
            }
        }
    }

    public String getURI() {
        return this.getCoordinatorId();
    }

    public boolean recover() throws SysException {
        this.printMsg("starting recover() for coordinator: " + this.getCoordinatorId(), 3);
        boolean bl = true;
        Enumeration enumeration = this.participants_.keys();
        while (enumeration.hasMoreElements()) {
            Participant participant = (Participant)enumeration.nextElement();
            boolean bl2 = false;
            try {
                bl2 = participant.recover();
                this.printMsg("coordinator: " + this.getCoordinatorId() + "recovered participant: " + participant, 3);
            }
            catch (Exception exception) {
                this.printMsg("Error in recovering participant");
                StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
                for (int i = 0; i < stackTraceElementArray.length; ++i) {
                    this.printMsg(stackTraceElementArray[i].toString());
                }
            }
            bl = bl && bl2;
        }
        this.stateHandler_.recover(this);
        boolean bl3 = !bl && this.getState().equals(TxState.IN_DOUBT);
        this.startThreads(DEFAULT_TIMEOUT, this.console_);
        this.printMsg("recover() done for coordinator: " + this.getCoordinatorId(), 3);
        return bl3;
    }

    public void forget() {
        this.stateHandler_.forget();
    }

    public void setCascadeList(Dictionary dictionary) throws SysException {
        this.stateHandler_.setCascadeList(dictionary);
    }

    public void setGlobalSiblingCount(int n) {
        this.stateHandler_.setGlobalSiblingCount(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare() throws RollbackException, IllegalStateException, HeurHazardException, HeurMixedException, SysException {
        if (this.getState().equals(TxState.PREPARING)) {
            throw new RollbackException("Recursion detected");
        }
        int n = 1;
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            n = this.stateHandler_.prepare();
            if (n == 0) {
                this.printMsg("prepare() of Coordinator  " + this.getCoordinatorId() + " returning READONLY", 3);
            } else {
                this.printMsg("prepare() of Coordinator  " + this.getCoordinatorId() + " returning YES vote", 3);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeuristicMessage[] commit(boolean bl) throws HeurRollbackException, HeurMixedException, HeurHazardException, IllegalStateException, RollbackException, SysException {
        HeuristicMessage[] heuristicMessageArray = null;
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            heuristicMessageArray = this.stateHandler_.commit(bl);
        }
        return heuristicMessageArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeuristicMessage[] rollback() throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException {
        if (this.getState().equals(TxState.ABORTING)) {
            return this.getHeuristicMessages();
        }
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            return this.stateHandler_.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeuristicMessage[] rollbackHeuristically() throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException {
        HeuristicMessage[] heuristicMessageArray = null;
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            heuristicMessageArray = this.stateHandler_.rollback(true, true);
        }
        return heuristicMessageArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeuristicMessage[] commitHeuristically() throws HeurMixedException, SysException, HeurRollbackException, HeurHazardException, IllegalStateException, RollbackException {
        HeuristicMessage[] heuristicMessageArray = null;
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            heuristicMessageArray = this.stateHandler_.commit(true, false);
        }
        return heuristicMessageArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean replayCompletion(Participant participant) throws IllegalStateException {
        this.printMsg("replayCompletion ( " + participant + " ) received by coordinator " + this.getCoordinatorId() + " for participant " + participant.toString(), 2);
        Boolean bl = null;
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            bl = this.stateHandler_.replayCompletion(participant);
        }
        return bl;
    }

    protected void restore(ObjectImage objectImage) {
        CoordinatorLogImage coordinatorLogImage = (CoordinatorLogImage)objectImage;
        this.root_ = coordinatorLogImage.root_;
        this.participants_ = coordinatorLogImage.participants_;
        this.coordinator_ = coordinatorLogImage.coordinator_;
        this.heuristicCommit_ = coordinatorLogImage.heuristicCommit_;
        this.maxIndoubtTicks_ = coordinatorLogImage.maxInquiries_;
        this.maxRollbackTicks_ = coordinatorLogImage.maxInquiries_;
        this.recoverableWhileActive_ = coordinatorLogImage.activity_;
        if (this.recoverableWhileActive_) {
            this.checkSiblings_ = coordinatorLogImage.checkSiblings_;
            this.localSiblingCount_ = coordinatorLogImage.localSiblingCount_;
        }
        this.fsm_ = new FSMImp((Object)this, (TransitionTable)new TransactionTransitionTable(), (Object)coordinatorLogImage.state_);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.TERMINATED);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.HEUR_COMMITTED);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.HEUR_ABORTED);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.HEUR_MIXED);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.HEUR_HAZARD);
        this.stateHandler_ = coordinatorLogImage.stateHandler_;
        if (coordinatorLogImage.state_.equals((Object)TxState.COMMITTING) && this.stateHandler_.getState().equals(TxState.ACTIVE)) {
            HeurHazardStateHandler heurHazardStateHandler = new HeurHazardStateHandler(this.stateHandler_, coordinatorLogImage.participants_);
            ((CoordinatorStateHandler)heurHazardStateHandler).recover(this);
            this.setStateHandler(heurHazardStateHandler);
        }
        this.single_threaded_2pc_ = coordinatorLogImage.single_threaded_2pc_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectImage getObjectImage() {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            return this.getObjectImage(this.getState());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectImage getObjectImage(Object object) {
        CoordinatorLogImage coordinatorLogImage = null;
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            if (!this.recoverableWhileActive_ && object.equals(TxState.ACTIVE)) {
                coordinatorLogImage = null;
            } else {
                TxState txState = (TxState)object;
                coordinatorLogImage = this.recoverableWhileActive_ ? new CoordinatorLogImage(this.root_, txState, this.participants_, this.coordinator_, this.heuristicCommit_, this.maxIndoubtTicks_, this.stateHandler_, this.localSiblingCount_, this.checkSiblings_, this.single_threaded_2pc_) : new CoordinatorLogImage(this.root_, txState, this.participants_, this.coordinator_, this.heuristicCommit_, this.maxIndoubtTicks_, this.stateHandler_, this.single_threaded_2pc_);
            }
        }
        return coordinatorLogImage;
    }

    public Object[] getRecoverableStates() {
        Object[] objectArray = new Object[]{TxState.ACTIVE, TxState.IN_DOUBT, TxState.COMMITTING, TxState.HEUR_COMMITTED, TxState.HEUR_ABORTED, TxState.HEUR_HAZARD, TxState.HEUR_MIXED};
        return objectArray;
    }

    public Object[] getFinalStates() {
        Object[] objectArray = new Object[]{TxState.TERMINATED};
        return objectArray;
    }

    public Object getId() {
        return this.root_;
    }

    public void alarm(AlarmTimer alarmTimer) {
        try {
            this.stateHandler_.onTimeout();
        }
        catch (Exception exception) {
            this.printMsg("Exception on timeout of coordinator " + this.root_ + ": " + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            if (this.timer_ != null) {
                Configuration.logDebug("Coordinator " + this.getCoordinatorId() + " : stopping timer...");
                this.timer_.stop();
            }
            Configuration.logDebug("Coordinator " + this.getCoordinatorId() + " : disposing statehandler " + this.stateHandler_.getState() + "...");
            this.stateHandler_.dispose();
            Configuration.logDebug("Coordinator " + this.getCoordinatorId() + " : disposed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void terminate(boolean bl) throws HeurRollbackException, HeurMixedException, SysException, SecurityException, HeurCommitException, HeurHazardException, RollbackException, IllegalStateException {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            if (bl) {
                if (this.participants_.size() <= 1) {
                    this.commit(true);
                } else {
                    int n = this.prepare();
                    if (n != 0) {
                        this.commit(false);
                    }
                }
            } else {
                this.rollback();
            }
        }
    }

    public void setRecoverableWhileActive() throws UnsupportedOperationException {
        this.recoverableWhileActive_ = true;
    }
}

