/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.imp.PropagationException;
import com.atomikos.icatch.imp.PropagationMessage;
import com.atomikos.icatch.imp.Result;
import com.atomikos.icatch.system.Configuration;

class CommitMessage
extends PropagationMessage {
    protected boolean onephase_ = false;
    protected int retrycount_ = 0;

    public CommitMessage(Participant participant, Result result, boolean bl) {
        super(participant, result);
        this.onephase_ = bl;
    }

    protected Object send() throws PropagationException {
        Participant participant = this.getParticipant();
        HeuristicMessage[] heuristicMessageArray = null;
        try {
            heuristicMessageArray = participant.commit(this.onephase_);
            return heuristicMessageArray;
        }
        catch (RollbackException rollbackException) {
            throw new PropagationException((Exception)((Object)rollbackException), false);
        }
        catch (HeurMixedException heurMixedException) {
            throw new PropagationException((Exception)((Object)heurMixedException), false);
        }
        catch (HeurRollbackException heurRollbackException) {
            throw new PropagationException((Exception)((Object)heurRollbackException), false);
        }
        catch (Exception exception) {
            String string = "Unexpected error in commit";
            Configuration.logWarning(string, exception);
            HeurHazardException heurHazardException = new HeurHazardException(participant.getHeuristicMessages());
            throw new PropagationException((Exception)heurHazardException, true);
        }
    }

    public String toString() {
        return "CommitMessage to " + this.getParticipant();
    }
}

