/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.spring;

import com.atomikos.jdbc.AtomikosDataSourceBean;
import com.atomikos.jdbc.AtomikosNonXADataSourceBean;
import com.atomikos.spring.AtomikosDataSourceBeanMetadata;
import com.atomikos.spring.AtomikosNonXADataSourceBeanMetadata;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.jdbc.DataSourceUnwrapper;
import org.springframework.boot.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AtomikosDataSourcePoolMetadataProvidersConfiguration {

    @Configuration
    @ConditionalOnClass(value={AtomikosNonXADataSourceBean.class})
    static class AtomikosNonXADataSourceBeanMetadataProviderConfiguration {
        AtomikosNonXADataSourceBeanMetadataProviderConfiguration() {
        }

        @Bean
        public DataSourcePoolMetadataProvider atomikosNonXADataSourceBeanMetadataProvider() {
            return dataSource -> {
                AtomikosNonXADataSourceBean atomikosDataSource = (AtomikosNonXADataSourceBean)DataSourceUnwrapper.unwrap((DataSource)dataSource, AtomikosNonXADataSourceBean.class);
                if (atomikosDataSource != null) {
                    return new AtomikosNonXADataSourceBeanMetadata(atomikosDataSource);
                }
                return null;
            };
        }
    }

    @Configuration
    @ConditionalOnClass(value={AtomikosDataSourceBean.class})
    static class AtomikosDataSourceBeanMetadataProviderConfiguration {
        AtomikosDataSourceBeanMetadataProviderConfiguration() {
        }

        @Bean
        public DataSourcePoolMetadataProvider atomikosDataSourceBeanMetadataProvider() {
            return dataSource -> {
                AtomikosDataSourceBean atomikosDataSource = (AtomikosDataSourceBean)DataSourceUnwrapper.unwrap((DataSource)dataSource, AtomikosDataSourceBean.class);
                if (atomikosDataSource != null) {
                    return new AtomikosDataSourceBeanMetadata(atomikosDataSource);
                }
                return null;
            };
        }
    }
}

