/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.jta;

import com.atomikos.icatch.OrderedLifecycleComponent;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.jta.TransactionImp;
import com.atomikos.icatch.jta.TransactionManagerImp;
import com.atomikos.util.SerializableObjectFactory;
import java.io.Serializable;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;

public class TransactionSynchronizationRegistryImp
implements TransactionSynchronizationRegistry,
Serializable,
Referenceable,
OrderedLifecycleComponent {
    private static final long serialVersionUID = 1L;
    private transient TransactionManager tm;

    private void assertTransactionManagerAvailable() {
        this.tm = TransactionManagerImp.getTransactionManager();
        if (this.tm == null) {
            throw new IllegalStateException("Transaction service not running");
        }
    }

    public Object getTransactionKey() {
        this.assertTransactionManagerAvailable();
        try {
            return this.tm.getTransaction();
        }
        catch (SystemException e) {
            throw new SysException((Throwable)e);
        }
    }

    public void putResource(Object key, Object value) {
        this.assertTransactionManagerAvailable();
        if (key == null) {
            throw new NullPointerException();
        }
        TransactionImp tx = null;
        try {
            tx = (TransactionImp)this.tm.getTransaction();
            if (tx != null) {
                tx.putResource(key, value);
            } else {
                this.throwNoTransactionFound();
            }
        }
        catch (SystemException e) {
            throw new SysException((Throwable)e);
        }
    }

    public Object getResource(Object key) {
        this.assertTransactionManagerAvailable();
        if (key == null) {
            throw new NullPointerException();
        }
        Object ret = null;
        TransactionImp tx = null;
        try {
            tx = (TransactionImp)this.tm.getTransaction();
            if (tx != null) {
                ret = tx.getResource(key);
            } else {
                this.throwNoTransactionFound();
            }
        }
        catch (SystemException e) {
            throw new SysException((Throwable)e);
        }
        return ret;
    }

    public void registerInterposedSynchronization(Synchronization sync) {
        this.assertTransactionManagerAvailable();
        TransactionImp tx = null;
        try {
            tx = (TransactionImp)this.tm.getTransaction();
            if (tx != null) {
                tx.registerInterposedSynchronization(sync);
            } else {
                this.throwNoTransactionFound();
            }
        }
        catch (SystemException e) {
            throw new SysException((Throwable)e);
        }
    }

    private void throwNoTransactionFound() {
        throw new IllegalStateException("No transaction found for calling thread");
    }

    public int getTransactionStatus() {
        this.assertTransactionManagerAvailable();
        try {
            return this.tm.getStatus();
        }
        catch (SystemException e) {
            throw new SysException((Throwable)e);
        }
    }

    public void setRollbackOnly() {
        this.assertTransactionManagerAvailable();
        try {
            this.tm.setRollbackOnly();
        }
        catch (SystemException e) {
            throw new SysException((Throwable)e);
        }
    }

    public boolean getRollbackOnly() {
        this.assertTransactionManagerAvailable();
        if (this.getTransactionStatus() == 6) {
            this.throwNoTransactionFound();
        }
        return false;
    }

    @Override
    public Reference getReference() throws NamingException {
        return SerializableObjectFactory.createReference((Serializable)this);
    }

    public void init() throws Exception {
    }

    public void close() throws Exception {
    }
}

