/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa;

import com.atomikos.datasource.ResourceException;
import com.atomikos.datasource.ResourceTransaction;
import com.atomikos.datasource.xa.StringUtils;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.datasource.xa.XID;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SysException;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.recovery.TxState;
import com.atomikos.util.Assert;
import java.util.Map;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceTransaction
implements ResourceTransaction,
Participant {
    private static final Logger LOGGER = LoggerFactory.createLogger(XAResourceTransaction.class);
    static final long serialVersionUID = -8227293322090019196L;
    private String tid;
    private String root;
    private boolean isXaSuspended;
    private TxState state;
    private String resourcename;
    private transient XID xid;
    private transient String xidToHexString;
    private transient String toString;
    private final transient XATransactionalResource resource;
    private transient XAResource xaresource;
    private transient boolean knownInResource;
    private transient int timeout;

    private static String interpretErrorCode(String resourceName, String opCode, Xid xid, int errorCode) {
        String msg = "unkown";
        switch (errorCode) {
            case -7: {
                msg = "the XA resource has become unavailable";
                break;
            }
            case 100: {
                msg = "the XA resource has rolled back for an unspecified reason";
                break;
            }
            case 101: {
                msg = "the XA resource rolled back due to a communication failure";
                break;
            }
            case 102: {
                msg = "the XA resource has rolled back because of a deadlock";
                break;
            }
            case 103: {
                msg = "the XA resource has rolled back due to a constraint violation";
                break;
            }
            case 104: {
                msg = "the XA resource has rolled back for an unknown reason";
                break;
            }
            case 105: {
                msg = "the XA resource has rolled back because it did not expect this command in the current context";
                break;
            }
            case 106: {
                msg = "the XA resource has rolled back because the transaction took too long";
                break;
            }
            case 107: {
                msg = "the XA resource has rolled back for a temporary reason - the transaction can be retried later";
                break;
            }
            case 9: {
                msg = "XA resume attempted in a different place from where suspend happened";
                break;
            }
            case 8: {
                msg = "the XA resource may have heuristically completed the transaction";
                break;
            }
            case 7: {
                msg = "the XA resource has heuristically committed";
                break;
            }
            case 6: {
                msg = "the XA resource has heuristically rolled back";
                break;
            }
            case 5: {
                msg = "the XA resource has heuristically committed some parts and rolled back other parts";
                break;
            }
            case 4: {
                msg = "the XA command had no effect and may be retried";
                break;
            }
            case 3: {
                msg = "the XA resource had no updates to perform for this transaction";
                break;
            }
            case -3: {
                msg = "the XA resource detected an internal error";
                break;
            }
            case -4: {
                msg = "the supplied XID is invalid for this XA resource";
                break;
            }
            case -5: {
                msg = "invalid arguments were given for the XA operation";
                break;
            }
            case -6: {
                msg = "the XA resource did not expect this command in the current context";
                break;
            }
            case -8: {
                msg = "the supplied XID already exists in this XA resource";
                break;
            }
            case -9: {
                msg = "the XA resource is currently involved in a local (non-XA) transaction";
                break;
            }
            default: {
                msg = "unknown";
            }
        }
        return "XA resource '" + resourceName + "': " + opCode + " for XID '" + XAResourceTransaction.xidToHexString(xid) + "' raised " + errorCode + ": " + msg;
    }

    private void setXid(XID xid) {
        this.xid = xid;
        this.xidToHexString = XAResourceTransaction.xidToHexString(xid);
        this.toString = "XAResourceTransaction: " + this.xidToHexString;
    }

    XAResourceTransaction(XATransactionalResource resource, CompositeTransaction transaction, String root) {
        Assert.notNull((String)"resource cannot be null", (Object)resource);
        this.resource = resource;
        this.timeout = (int)transaction.getTimeout() / 1000;
        this.tid = transaction.getTid();
        this.root = root;
        this.resourcename = resource.getName();
        this.setXid(this.resource.createXid(this.tid));
        this.setState(TxState.ACTIVE);
        this.isXaSuspended = false;
        this.knownInResource = false;
    }

    void setState(TxState state) {
        if (state.isHeuristic()) {
            LOGGER.logError("Heuristic termination of " + this.toString() + " with state " + state);
        }
        this.state = state;
    }

    static String xidToHexString(Xid xid) {
        String gtrid = StringUtils.byteArrayToHexString(xid.getGlobalTransactionId());
        String bqual = StringUtils.byteArrayToHexString(xid.getBranchQualifier());
        return gtrid + ":" + bqual;
    }

    protected void testOrRefreshXAResourceFor2PC() throws XAException {
        try {
            if (this.state == TxState.HEUR_HAZARD) {
                this.forceRefreshXAConnection();
            } else if (this.xaresource != null) {
                this.assertConnectionIsStillAlive();
            }
        }
        catch (XAException xa) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace(this.resourcename + ": XAResource needs refresh", (Throwable)xa);
            }
            this.xaresource = this.resource.getXAResource();
        }
    }

    private void assertConnectionIsStillAlive() throws XAException {
        this.xaresource.isSameRM(this.xaresource);
    }

    private void forceRefreshXAConnection() throws XAException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this.resourcename + ": forcing refresh of XAConnection...");
        }
        try {
            this.xaresource = this.resource.refreshXAConnection();
        }
        catch (ResourceException re) {
            LOGGER.logWarning(this.resourcename + ": could not refresh XAConnection", (Throwable)re);
        }
    }

    private void terminateInResource() {
        if (this.resource != null) {
            this.resource.removeSiblingMap(this.root);
        }
    }

    public String getTid() {
        return this.tid;
    }

    public synchronized void suspend() throws ResourceException {
        if (this.state.equals((Object)TxState.ACTIVE)) {
            block4: {
                try {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.logDebug("XAResource.end ( " + this.xidToHexString + " , XAResource.TMSUCCESS ) on resource " + this.resourcename + " represented by XAResource instance " + this.xaresource);
                    }
                    this.xaresource.end(this.xid, 0x4000000);
                }
                catch (XAException xaerr) {
                    String msg = XAResourceTransaction.interpretErrorCode(this.resourcename, "end", this.xid, xaerr.errorCode);
                    if (!LOGGER.isTraceEnabled()) break block4;
                    LOGGER.logTrace(msg, (Throwable)xaerr);
                }
            }
            this.setState(TxState.LOCALLY_DONE);
        }
    }

    boolean supportsTmJoin() {
        return !this.resource.usesWeakCompare() && !this.resource.acceptsAllXAResources() && !this.isActive();
    }

    public synchronized void resume() throws ResourceException {
        int flag = 0;
        String logFlag = "";
        if (this.state.equals((Object)TxState.LOCALLY_DONE)) {
            flag = 0x200000;
            logFlag = "XAResource.TMJOIN";
        } else if (!this.knownInResource) {
            flag = 0;
            logFlag = "XAResource.TMNOFLAGS";
        } else {
            throw new IllegalStateException("Wrong state for resume: " + this.state);
        }
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("XAResource.start ( " + this.xidToHexString + " , " + logFlag + " ) on resource " + this.resourcename + " represented by XAResource instance " + this.xaresource);
            }
            this.xaresource.start(this.xid, flag);
        }
        catch (XAException xaerr) {
            String msg = XAResourceTransaction.interpretErrorCode(this.resourcename, "resume", this.xid, xaerr.errorCode);
            LOGGER.logWarning(msg, (Throwable)xaerr);
            throw new ResourceException(msg, (Throwable)xaerr);
        }
        this.setState(TxState.ACTIVE);
        this.knownInResource = true;
    }

    public void setCascadeList(Map<String, Integer> allParticipants) throws SysException {
    }

    public Object getState() {
        return this.state;
    }

    private boolean beforePrepare() {
        return TxState.ACTIVE.equals((Object)this.state) || TxState.LOCALLY_DONE.equals((Object)this.state);
    }

    public void setGlobalSiblingCount(int count) {
    }

    public synchronized void forget() {
        this.terminateInResource();
        try {
            if (this.xaresource != null) {
                this.xaresource.forget(this.xid);
            }
        }
        catch (Exception err) {
            LOGGER.logTrace("Error forgetting xid: " + this.xid, (Throwable)err);
        }
        this.setState(TxState.TERMINATED);
    }

    public synchronized int prepare() throws RollbackException, HeurHazardException, HeurMixedException, SysException {
        int ret = 0;
        this.terminateInResource();
        if (TxState.ACTIVE == this.state) {
            this.suspend();
        }
        if (this.state == TxState.IN_DOUBT) {
            return 0;
        }
        if (this.state != TxState.LOCALLY_DONE) {
            throw new SysException("Wrong state for prepare: " + this.state);
        }
        try {
            this.testOrRefreshXAResourceFor2PC();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace("About to call prepare on XAResource instance: " + this.xaresource);
            }
            ret = this.xaresource.prepare(this.xid);
        }
        catch (XAException xaerr) {
            String msg = XAResourceTransaction.interpretErrorCode(this.resourcename, "prepare", this.xid, xaerr.errorCode);
            LOGGER.logWarning(msg, (Throwable)xaerr);
            if (100 <= xaerr.errorCode && xaerr.errorCode <= 107) {
                throw new RollbackException(msg);
            }
            LOGGER.logError(msg, (Throwable)xaerr);
            throw new SysException(msg, (Throwable)xaerr);
        }
        this.setState(TxState.IN_DOUBT);
        if (ret == 3) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("XAResource.prepare ( " + this.xidToHexString + " ) returning XAResource.XA_RDONLY " + "on resource " + this.resourcename + " represented by XAResource instance " + this.xaresource);
            }
            return 0;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug("XAResource.prepare ( " + this.xidToHexString + " ) returning OK " + "on resource " + this.resourcename + " represented by XAResource instance " + this.xaresource);
        }
        return 1;
    }

    public synchronized void rollback() throws HeurCommitException, HeurMixedException, HeurHazardException, SysException {
        this.terminateInResource();
        if (this.rollbackShouldDoNothing()) {
            return;
        }
        if (this.state.equals((Object)TxState.TERMINATED)) {
            return;
        }
        if (this.state.equals((Object)TxState.HEUR_MIXED)) {
            throw new HeurMixedException();
        }
        if (this.state.equals((Object)TxState.HEUR_COMMITTED)) {
            throw new HeurCommitException();
        }
        if (this.xaresource == null) {
            throw new HeurHazardException("XAResourceTransaction " + this.getXid() + ": no XAResource to rollback?");
        }
        try {
            if (this.state.equals((Object)TxState.ACTIVE)) {
                this.suspend();
            }
            this.testOrRefreshXAResourceFor2PC();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("XAResource.rollback ( " + this.xidToHexString + " ) " + "on resource " + this.resourcename + " represented by XAResource instance " + this.xaresource);
            }
            this.xaresource.rollback(this.xid);
        }
        catch (ResourceException resErr) {
            throw new SysException("Error in rollback: " + resErr.getMessage(), (Throwable)resErr);
        }
        catch (XAException xaerr) {
            String msg = XAResourceTransaction.interpretErrorCode(this.resourcename, "rollback", this.xid, xaerr.errorCode);
            if (100 <= xaerr.errorCode && xaerr.errorCode <= 107) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.logTrace(msg);
                }
            }
            LOGGER.logWarning(msg, (Throwable)xaerr);
            switch (xaerr.errorCode) {
                case 8: {
                    this.setState(TxState.HEUR_HAZARD);
                    throw new HeurHazardException();
                }
                case 5: {
                    this.setState(TxState.HEUR_MIXED);
                    throw new HeurMixedException();
                }
                case 7: {
                    this.setState(TxState.HEUR_COMMITTED);
                    throw new HeurCommitException();
                }
                case 6: {
                    this.forget();
                    break;
                }
                case -4: {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.logTrace("XAResource.rollback: invalid Xid - already rolled back in resource?");
                    }
                    this.setState(TxState.TERMINATED);
                    break;
                }
                default: {
                    this.setState(TxState.HEUR_HAZARD);
                    throw new SysException(msg, (Throwable)xaerr);
                }
            }
        }
        this.setState(TxState.TERMINATED);
    }

    private boolean rollbackShouldDoNothing() {
        return !this.knownInResource && this.beforePrepare();
    }

    public synchronized void commit(boolean onePhase) throws HeurRollbackException, HeurHazardException, HeurMixedException, RollbackException, SysException {
        this.terminateInResource();
        if (this.state.equals((Object)TxState.TERMINATED)) {
            return;
        }
        if (this.state.equals((Object)TxState.HEUR_MIXED)) {
            throw new HeurMixedException();
        }
        if (this.state.equals((Object)TxState.HEUR_ABORTED)) {
            throw new HeurRollbackException();
        }
        if (this.xaresource == null) {
            String msg = this.toString + ": no XAResource to commit?";
            LOGGER.logError(msg);
            throw new HeurHazardException(msg);
        }
        try {
            if (TxState.ACTIVE.equals((Object)this.state)) {
                this.suspend();
            }
        }
        catch (ResourceException re) {
            throw new RollbackException(re.getMessage());
        }
        if (!this.state.isOneOf(new TxState[]{TxState.LOCALLY_DONE, TxState.IN_DOUBT, TxState.HEUR_HAZARD})) {
            throw new SysException("Wrong state for commit: " + this.state);
        }
        try {
            this.testOrRefreshXAResourceFor2PC();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("XAResource.commit ( " + this.xidToHexString + " , " + onePhase + " ) on resource " + this.resourcename + " represented by XAResource instance " + this.xaresource);
            }
            this.xaresource.commit(this.xid, onePhase);
        }
        catch (XAException xaerr) {
            String msg = XAResourceTransaction.interpretErrorCode(this.resourcename, "commit", this.xid, xaerr.errorCode);
            LOGGER.logWarning(msg, (Throwable)xaerr);
            if (100 <= xaerr.errorCode && xaerr.errorCode <= 107) {
                if (!onePhase) {
                    throw new SysException(msg, (Throwable)xaerr);
                }
                throw new RollbackException("Already rolled back in resource.");
            }
            switch (xaerr.errorCode) {
                case 8: {
                    this.setState(TxState.HEUR_HAZARD);
                    throw new HeurHazardException();
                }
                case 5: {
                    this.setState(TxState.HEUR_MIXED);
                    throw new HeurMixedException();
                }
                case 7: {
                    this.forget();
                    break;
                }
                case 6: {
                    this.setState(TxState.HEUR_ABORTED);
                    throw new HeurRollbackException();
                }
                case -4: {
                    if (!onePhase) {
                        LOGGER.logWarning("XAResource.commit: invalid Xid - transaction already committed in resource?");
                        this.setState(TxState.TERMINATED);
                        break;
                    }
                }
                default: {
                    this.setState(TxState.HEUR_HAZARD);
                    throw new SysException(msg, (Throwable)xaerr);
                }
            }
        }
        this.setState(TxState.TERMINATED);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XAResourceTransaction)) {
            return false;
        }
        XAResourceTransaction other = (XAResourceTransaction)o;
        return this.xid.equals(other.xid);
    }

    public int hashCode() {
        return this.xidToHexString.hashCode();
    }

    public String toString() {
        return this.toString;
    }

    public Xid getXid() {
        return this.xid;
    }

    public void setXAResource(XAResource xaresource) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": about to switch to XAResource " + xaresource);
        }
        this.xaresource = xaresource;
        try {
            this.xaresource.setTransactionTimeout(this.timeout);
        }
        catch (XAException e) {
            String msg = XAResourceTransaction.interpretErrorCode(this.resourcename, "setTransactionTimeout", this.xid, e.errorCode);
            LOGGER.logWarning(msg, (Throwable)e);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace("XAResourceTransaction " + this.getXid() + ": switched to XAResource " + xaresource);
        }
    }

    public void xaSuspend() throws XAException {
        if (!this.isXaSuspended) {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.logDebug("XAResource.suspend ( " + this.xidToHexString + " , XAResource.TMSUSPEND ) on resource " + this.resourcename + " represented by XAResource instance " + this.xaresource);
                }
                this.xaresource.end(this.xid, 0x2000000);
                this.isXaSuspended = true;
            }
            catch (XAException xaerr) {
                String msg = XAResourceTransaction.interpretErrorCode(this.resourcename, "suspend", this.xid, xaerr.errorCode);
                LOGGER.logWarning(msg, (Throwable)xaerr);
                throw xaerr;
            }
        }
    }

    public void xaResume() throws XAException {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("XAResource.start ( " + this.xidToHexString + " , XAResource.TMRESUME ) on resource " + this.resourcename + " represented by XAResource instance " + this.xaresource);
            }
            this.xaresource.start(this.xid, 0x8000000);
            this.isXaSuspended = false;
        }
        catch (XAException xaerr) {
            String msg = XAResourceTransaction.interpretErrorCode(this.resourcename, "resume", this.xid, xaerr.errorCode);
            LOGGER.logWarning(msg, (Throwable)xaerr);
            throw xaerr;
        }
    }

    public boolean isXaSuspended() {
        return this.isXaSuspended;
    }

    public boolean isActive() {
        return this.state.equals((Object)TxState.ACTIVE);
    }

    public String getURI() {
        return this.xid.getBranchQualifierAsString();
    }

    public String getResourceName() {
        return this.resourcename;
    }

    public boolean isRecoverable() {
        return true;
    }
}

