/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.datasource.TransactionalResource;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jms.DefaultJtaMessageConsumer;
import com.atomikos.jms.DefaultJtaMessageProducer;
import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.jms.TransactionInProgressException;
import javax.jms.XASession;
import javax.transaction.xa.XAResource;

class DefaultJtaSession
implements Session {
    private XASession session_;
    private TransactionalResource res_;
    private XAResource xares_;

    DefaultJtaSession(XASession xASession, TransactionalResource transactionalResource, XAResource xAResource) {
        this.session_ = xASession;
        this.res_ = transactionalResource;
        this.xares_ = xAResource;
    }

    protected Session getSession() {
        Session session = null;
        try {
            session = this.session_.getSession();
        }
        catch (JMSException jMSException) {
            throw new RuntimeException(jMSException);
        }
        return session;
    }

    protected TransactionalResource getTransactionalResource() {
        return this.res_;
    }

    protected XAResource getXAResource() {
        return this.xares_;
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        return this.getSession().createTemporaryQueue();
    }

    public QueueBrowser createBrowser(Queue queue, String string) throws JMSException {
        return this.getSession().createBrowser(queue, string);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.getSession().createBrowser(queue);
    }

    public Queue createQueue(String string) throws JMSException {
        return this.getSession().createQueue(string);
    }

    public void commit() throws JMSException {
        throw new TransactionInProgressException("XA Session: commit not allowed on session");
    }

    public void rollback() throws JMSException {
        throw new TransactionInProgressException("XA Session: rollback not allowed on session");
    }

    public boolean getTransacted() throws JMSException {
        return true;
    }

    public void run() {
        this.getSession().run();
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.getSession().setMessageListener(messageListener);
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.getSession().getMessageListener();
    }

    public void recover() throws JMSException {
        throw new IllegalStateException("Transacted session: recover not allowed");
    }

    public void close() throws JMSException {
        Configuration.logDebug((String)"Closing JMS session...");
        this.session_.close();
        Configuration.logInfo((String)"Closed JMS session");
    }

    public TextMessage createTextMessage() throws JMSException {
        return this.getSession().createTextMessage();
    }

    public TextMessage createTextMessage(String string) throws JMSException {
        return this.getSession().createTextMessage(string);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return this.getSession().createStreamMessage();
    }

    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        return this.getSession().createObjectMessage(serializable);
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return this.getSession().createObjectMessage();
    }

    public Message createMessage() throws JMSException {
        return this.getSession().createMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        return this.getSession().createMapMessage();
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return this.getSession().createBytesMessage();
    }

    public int getAcknowledgeMode() throws JMSException {
        return this.getSession().getAcknowledgeMode();
    }

    public Topic createTopic(String string) throws JMSException {
        return this.getSession().createTopic(string);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string) throws JMSException {
        return this.getSession().createDurableSubscriber(topic, string);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string, String string2, boolean bl) throws JMSException {
        return this.getSession().createDurableSubscriber(topic, string, string2, bl);
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        return this.getSession().createTemporaryTopic();
    }

    public void unsubscribe(String string) throws JMSException {
        this.getSession().unsubscribe(string);
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        MessageProducer messageProducer = this.getSession().createProducer(destination);
        return new DefaultJtaMessageProducer(messageProducer, this.res_, this.xares_);
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        MessageConsumer messageConsumer = this.getSession().createConsumer(destination);
        return new DefaultJtaMessageConsumer(messageConsumer, this.res_, this.xares_);
    }

    public MessageConsumer createConsumer(Destination destination, String string) throws JMSException {
        MessageConsumer messageConsumer = this.getSession().createConsumer(destination, string);
        return new DefaultJtaMessageConsumer(messageConsumer, this.res_, this.xares_);
    }

    public MessageConsumer createConsumer(Destination destination, String string, boolean bl) throws JMSException {
        MessageConsumer messageConsumer = this.getSession().createConsumer(destination, string, bl);
        return new DefaultJtaMessageConsumer(messageConsumer, this.res_, this.xares_);
    }
}

