/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc;

import com.atomikos.datasource.TransactionalResource;
import com.atomikos.datasource.xa.XidFactory;
import com.atomikos.datasource.xa.jdbc.JdbcTransactionalResource;
import com.atomikos.jdbc.ConnectionFactory;
import com.atomikos.jdbc.ExclusiveExternalXAPooledConnectionImp;
import com.atomikos.jdbc.ExternalXAPooledConnectionImp;
import com.atomikos.jdbc.XPooledConnection;
import java.io.PrintWriter;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class XAConnectionFactory
implements ConnectionFactory {
    private String userName_;
    private String passwd_;
    private String resourceName_;
    private XADataSource ds_;
    private JdbcTransactionalResource res_;
    private boolean exclusive_;

    protected XAConnectionFactory(String string, String string2, String string3, XADataSource xADataSource, JdbcTransactionalResource jdbcTransactionalResource) {
        this.resourceName_ = string;
        this.userName_ = string2;
        this.passwd_ = string3;
        this.ds_ = xADataSource;
        this.res_ = jdbcTransactionalResource;
        if (string2 != null && !string2.equals("")) {
            this.res_.setUser(string2);
            this.res_.setPassword(string3);
        }
        this.exclusive_ = false;
    }

    public XAConnectionFactory(String string, String string2, String string3, XADataSource xADataSource) {
        this.resourceName_ = string;
        this.userName_ = string2;
        this.passwd_ = string3;
        this.ds_ = xADataSource;
        this.res_ = new JdbcTransactionalResource(string, this.ds_);
        this.res_.setUser(string2);
        this.res_.setPassword(string3);
        this.exclusive_ = false;
    }

    public XAConnectionFactory(String string, String string2, String string3, XADataSource xADataSource, XidFactory xidFactory) {
        this.resourceName_ = string;
        this.userName_ = string2;
        this.passwd_ = string3;
        this.ds_ = xADataSource;
        this.res_ = new JdbcTransactionalResource(string, this.ds_, xidFactory);
        this.res_.setUser(string2);
        this.res_.setPassword(string3);
        this.exclusive_ = false;
    }

    protected String getUserName() {
        return this.userName_;
    }

    protected String getPassword() {
        return this.passwd_;
    }

    public XADataSource getXADataSource() {
        return this.ds_;
    }

    public void setExclusive(boolean bl) {
        this.exclusive_ = bl;
    }

    public boolean isExclusive() {
        return this.exclusive_;
    }

    public TransactionalResource getTransactionalResource() {
        return this.res_;
    }

    public XPooledConnection getPooledConnection() throws IllegalStateException, SQLException {
        XAConnection xAConnection = null;
        ExternalXAPooledConnectionImp externalXAPooledConnectionImp = null;
        if (this.getTransactionalResource() == null) {
            throw new IllegalStateException("XAConnectionFactory: no tx resource");
        }
        xAConnection = this.getUserName() == null || this.getUserName().equals("") ? this.getXADataSource().getXAConnection() : this.getXADataSource().getXAConnection(this.getUserName(), this.getPassword());
        externalXAPooledConnectionImp = !this.exclusive_ ? new ExternalXAPooledConnectionImp(xAConnection, this.getTransactionalResource(), this.getLogWriter()) : new ExclusiveExternalXAPooledConnectionImp(xAConnection, this.getTransactionalResource(), this.getLogWriter());
        return externalXAPooledConnectionImp;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.getXADataSource().getLogWriter();
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.getXADataSource().setLogWriter(printWriter);
    }

    public int getLoginTimeout() throws SQLException {
        return this.getXADataSource().getLoginTimeout();
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.getXADataSource().setLoginTimeout(n);
    }
}

