/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc;

import com.atomikos.datasource.RecoverableResource;
import com.atomikos.datasource.TransactionalResource;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.StringHeuristicMessage;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jdbc.ConnectionPool;
import com.atomikos.jdbc.DTPPooledConnection;
import com.atomikos.jdbc.HeuristicDataSource;
import com.atomikos.jdbc.XAConnectionFactory;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class JtaDataSourceImp
implements HeuristicDataSource,
ConnectionEventListener,
Referenceable,
ConnectionPoolDataSource {
    private static Map nameToDataSource_ = new HashMap();
    private ConnectionPool pool_;
    private TransactionalResource resource_;
    private XAConnectionFactory fact_;
    private boolean autoRegister_;
    static /* synthetic */ Class class$com$atomikos$jdbc$JtaDataSourceImp;
    static /* synthetic */ Class class$com$atomikos$jdbc$JtaDataSourceImpFactory;

    static Reference createReference(String string) {
        StringRefAddr stringRefAddr = new StringRefAddr("ResourceName", string);
        Class clazz = class$com$atomikos$jdbc$JtaDataSourceImp == null ? (class$com$atomikos$jdbc$JtaDataSourceImp = JtaDataSourceImp.class$("com.atomikos.jdbc.JtaDataSourceImp")) : class$com$atomikos$jdbc$JtaDataSourceImp;
        Reference reference = new Reference(clazz.getName(), new StringRefAddr("name", "JtaDataSourceImp"), (class$com$atomikos$jdbc$JtaDataSourceImpFactory == null ? (class$com$atomikos$jdbc$JtaDataSourceImpFactory = JtaDataSourceImp.class$("com.atomikos.jdbc.JtaDataSourceImpFactory")) : class$com$atomikos$jdbc$JtaDataSourceImpFactory).getName(), null);
        reference.add(stringRefAddr);
        return reference;
    }

    static JtaDataSourceImp getInstance(String string) {
        JtaDataSourceImp jtaDataSourceImp = (JtaDataSourceImp)nameToDataSource_.get(string);
        return jtaDataSourceImp;
    }

    private static synchronized void addToMap(String string, JtaDataSourceImp jtaDataSourceImp) throws SQLException {
        if (nameToDataSource_.get(string) != null) {
            throw new SQLException("DataSource for resource " + string + " already exists!");
        }
        nameToDataSource_.put(string, jtaDataSourceImp);
    }

    private static synchronized void removeFromMap(String string) {
        if (string != null && nameToDataSource_ != null) {
            nameToDataSource_.remove(string);
        }
    }

    public JtaDataSourceImp(XAConnectionFactory xAConnectionFactory, int n, int n2, String string, boolean bl) throws SQLException {
        this(xAConnectionFactory, n, n2, false, false, string, bl);
    }

    JtaDataSourceImp(XAConnectionFactory xAConnectionFactory, int n, int n2, boolean bl, boolean bl2, String string, boolean bl3) throws SQLException {
        this.fact_ = xAConnectionFactory;
        this.pool_ = new ConnectionPool(n, xAConnectionFactory, n2, string, bl3);
        this.resource_ = xAConnectionFactory.getTransactionalResource();
        this.autoRegister_ = bl2;
        if (!bl) {
            JtaDataSourceImp.addToMap(this.resource_.getName(), this);
        }
        if (bl2) {
            Configuration.addResource((RecoverableResource)this.resource_);
        }
    }

    public Connection getConnection() throws SQLException {
        HeuristicMessage heuristicMessage = null;
        return this.getConnection(heuristicMessage);
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        throw new SQLException("Not supported: getConnection ( user , passwd )");
    }

    public Connection getConnection(String string, String string2, HeuristicMessage heuristicMessage) throws SQLException {
        throw new SQLException("Not supported: getConnection ( user , passwd )");
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.pool_.getLogWriter();
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.pool_.setLogWriter(printWriter);
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.pool_.setLoginTimeout(n);
    }

    public int getLoginTimeout() throws SQLException {
        return this.pool_.getLoginTimeout();
    }

    public void close() {
        this.pool_.cleanup();
        JtaDataSourceImp.removeFromMap(this.resource_.getName());
        if (this.autoRegister_) {
            Configuration.removeResource((String)this.resource_.getName());
        }
    }

    public TransactionalResource getTransactionalResource() {
        return this.resource_;
    }

    public Reference getReference() throws NamingException {
        return JtaDataSourceImp.createReference(this.resource_.getName());
    }

    public Connection getConnection(HeuristicMessage heuristicMessage) throws SQLException {
        DTPPooledConnection dTPPooledConnection = (DTPPooledConnection)this.pool_.getPooledConnection();
        dTPPooledConnection.addConnectionEventListener(this);
        return dTPPooledConnection.getConnection(heuristicMessage);
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        DTPPooledConnection dTPPooledConnection = (DTPPooledConnection)connectionEvent.getSource();
        if (dTPPooledConnection.isDiscarded()) {
            dTPPooledConnection.removeConnectionEventListener(this);
            this.pool_.putBack(dTPPooledConnection);
        }
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        DTPPooledConnection dTPPooledConnection = (DTPPooledConnection)connectionEvent.getSource();
        dTPPooledConnection.removeConnectionEventListener(this);
        dTPPooledConnection.setInvalidated();
    }

    public PooledConnection getPooledConnection() throws SQLException {
        return this.fact_.getPooledConnection();
    }

    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        throw new SQLException("Not supported.");
    }

    public Connection getConnection(String string) throws SQLException {
        StringHeuristicMessage stringHeuristicMessage = new StringHeuristicMessage(string);
        return this.getConnection((HeuristicMessage)stringHeuristicMessage);
    }

    public Connection getConnection(String string, String string2, String string3) throws SQLException {
        StringHeuristicMessage stringHeuristicMessage = new StringHeuristicMessage(string3);
        return this.getConnection(string, string2, (HeuristicMessage)stringHeuristicMessage);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

