/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.jta;

import com.atomikos.icatch.SysException;
import com.atomikos.icatch.jta.RemoteClientUserTransaction;
import com.atomikos.icatch.jta.TransactionImp;
import com.atomikos.icatch.jta.TransactionManagerImp;
import com.atomikos.icatch.jta.UserTransactionServer;
import com.atomikos.icatch.system.Configuration;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;

public class UserTransactionServerImp
implements UserTransactionServer {
    private static UserTransactionServerImp singleton_ = null;
    private TransactionManagerImp tm_;
    private String name_ = "UserTransactionServer";
    private boolean exported_ = false;
    private String initialContextFactory_;
    private String providerUrl_;
    private Properties properties_;

    public static synchronized UserTransactionServerImp getSingleton() {
        if (singleton_ == null) {
            singleton_ = new UserTransactionServerImp();
        }
        return singleton_;
    }

    private UserTransactionServerImp() {
    }

    private Context getInitialContext() throws NamingException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Enumeration<?> enumeration = this.properties_.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.properties_.getProperty(string);
            hashtable.put(string, string2);
        }
        return new InitialContext(hashtable);
    }

    public UserTransaction getUserTransaction() {
        RemoteClientUserTransaction remoteClientUserTransaction = null;
        if (this.exported_) {
            remoteClientUserTransaction = new RemoteClientUserTransaction(this.getName(), this.initialContextFactory_, this.providerUrl_);
        }
        return remoteClientUserTransaction;
    }

    public String getName() {
        return this.name_;
    }

    public void init(String string, Properties properties) throws SysException {
        boolean bl = false;
        String string2 = properties.getProperty("com.atomikos.icatch.rmi_export_class");
        boolean bl2 = bl = "UnicastRemoteObject".equals(string2) || "PortableRemoteObject".equals(string2);
        if (!bl) {
            Configuration.logWarning((String)("Client transaction demarcation not supported for com.atomikos.icatch.rmi_export_class=" + string2));
            this.exported_ = false;
        } else {
            this.name_ = string + "UserTransactionServer";
            this.providerUrl_ = properties.getProperty("java.naming.provider.url");
            if (this.providerUrl_ == null) {
                throw new SysException("Startup property java.naming.provider.url must be set for client demarcation.");
            }
            this.initialContextFactory_ = properties.getProperty("java.naming.factory.initial");
            if (this.initialContextFactory_ == null) {
                throw new SysException("Startup property java.naming.factory.initial must be set for client demarcation.");
            }
            this.properties_ = properties;
            this.tm_ = (TransactionManagerImp)TransactionManagerImp.getTransactionManager();
            if (this.tm_ == null) {
                throw new SysException("No TM found");
            }
            try {
                if ("PortableRemoteObject".equals(string2)) {
                    PortableRemoteObject.exportObject((Remote)this);
                    this.exported_ = true;
                } else if ("UnicastRemoteObject".equals(string2)) {
                    UnicastRemoteObject.exportObject(this);
                    this.exported_ = true;
                }
            }
            catch (Exception exception) {
                Stack<Exception> stack = new Stack<Exception>();
                stack.push(exception);
                throw new SysException("Error exporting - naming service not running?", stack);
            }
            try {
                Context context = this.getInitialContext();
                context.rebind(this.name_, (Object)this);
            }
            catch (Exception exception) {
                Stack<Exception> stack = new Stack<Exception>();
                stack.push(exception);
                throw new SysException("Please make sure the rmiregistry is running!?", stack);
            }
        }
    }

    public void shutdown() throws SysException {
        if (this.exported_) {
            String string = this.properties_.getProperty("com.atomikos.icatch.rmi_export_class");
            try {
                if ("PortableRemoteObject".equals(string)) {
                    PortableRemoteObject.unexportObject((Remote)this);
                } else if ("UnicastRemoteObject".equals(string)) {
                    UnicastRemoteObject.unexportObject(this, true);
                }
                Context context = this.getInitialContext();
                context.unbind(this.name_);
            }
            catch (Exception exception) {
                Stack<Exception> stack = new Stack<Exception>();
                stack.push(exception);
                throw new SysException(exception.getMessage(), stack);
            }
            this.exported_ = false;
        }
    }

    public String begin(int n) throws RemoteException, SystemException, NotSupportedException {
        this.tm_.begin(n);
        TransactionImp transactionImp = (TransactionImp)this.tm_.getTransaction();
        transactionImp.getCT().getTransactionControl().setSerial();
        this.tm_.suspend();
        return transactionImp.getCT().getTid();
    }

    public void commit(String string) throws RemoteException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        TransactionImp transactionImp = this.tm_.getPreviousInstance(string);
        if (transactionImp == null) {
            throw new RollbackException("Transaction not found: " + string);
        }
        transactionImp.commit();
    }

    public void rollback(String string) throws RemoteException, IllegalStateException, SecurityException, SystemException {
        TransactionImp transactionImp = this.tm_.getPreviousInstance(string);
        if (transactionImp != null) {
            transactionImp.rollback();
        }
    }

    public void setRollbackOnly(String string) throws RemoteException, IllegalStateException, SystemException {
        TransactionImp transactionImp = this.tm_.getPreviousInstance(string);
        if (transactionImp != null) {
            transactionImp.setRollbackOnly();
        }
    }

    public int getStatus(String string) throws RemoteException, SystemException {
        int n = 6;
        TransactionImp transactionImp = this.tm_.getPreviousInstance(string);
        if (transactionImp != null) {
            n = transactionImp.getStatus();
        }
        return n;
    }
}

