/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa.jms;

import com.atomikos.datasource.ResourceException;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.datasource.xa.XidFactory;
import java.util.Stack;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XASession;
import javax.transaction.xa.XAResource;

public class JmsTransactionalResource
extends XATransactionalResource {
    private XAConnectionFactory factory_;
    private XAConnection conn_;

    public JmsTransactionalResource(String string, XAConnectionFactory xAConnectionFactory) {
        super(string);
        this.factory_ = xAConnectionFactory;
        this.conn_ = null;
    }

    public JmsTransactionalResource(String string, XAConnectionFactory xAConnectionFactory, XidFactory xidFactory) {
        super(string, xidFactory);
        this.factory_ = xAConnectionFactory;
        this.conn_ = null;
    }

    protected synchronized XAResource refreshXAConnection() throws ResourceException {
        XAResource xAResource = null;
        if (this.conn_ != null) {
            try {
                this.conn_.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.conn_ = this.factory_.createXAConnection();
            XASession xASession = this.conn_.createXASession();
            xAResource = xASession.getXAResource();
        }
        catch (JMSException jMSException) {
            Stack<JMSException> stack = new Stack<JMSException>();
            stack.push(jMSException);
            throw new ResourceException("Error in getting XA resource", stack);
        }
        return xAResource;
    }

    public void close() throws ResourceException {
        super.close();
        try {
            if (this.conn_ != null) {
                this.conn_.close();
            }
        }
        catch (JMSException jMSException) {
            throw new ResourceException(jMSException.getMessage());
        }
    }
}

