/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa.jdbc;

import com.atomikos.datasource.ResourceException;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.datasource.xa.XidFactory;
import java.sql.SQLException;
import java.util.Stack;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;

public class JdbcTransactionalResource
extends XATransactionalResource {
    private XADataSource xads_;
    private XAConnection conn_;
    private String user_;
    private String password_;

    public JdbcTransactionalResource(String string, XADataSource xADataSource) {
        super(string);
        this.xads_ = xADataSource;
        if (this.xads_ == null) {
            throw new RuntimeException("Null XADataSource argument");
        }
        this.conn_ = null;
    }

    public JdbcTransactionalResource(String string, XADataSource xADataSource, XidFactory xidFactory) {
        super(string, xidFactory);
        this.xads_ = xADataSource;
        this.conn_ = null;
    }

    private String getUser() {
        String string = "";
        if (this.user_ != null) {
            string = this.user_;
        }
        return string;
    }

    private String getPassword() {
        String string = "";
        if (this.password_ != null) {
            string = this.password_;
        }
        return string;
    }

    protected synchronized XAResource refreshXAConnection() throws ResourceException {
        XAResource xAResource = null;
        if (this.conn_ != null) {
            try {
                this.conn_.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            try {
                this.conn_ = "".equals(this.getUser()) ? this.xads_.getXAConnection() : this.xads_.getXAConnection(this.getUser(), this.getPassword());
            }
            catch (SQLException sQLException) {
                this.conn_ = null;
            }
            if (this.conn_ != null) {
                xAResource = this.conn_.getXAResource();
            }
        }
        catch (SQLException sQLException) {
            Stack<SQLException> stack = new Stack<SQLException>();
            stack.push(sQLException);
            throw new ResourceException("Error in getting XA resource", stack);
        }
        return xAResource;
    }

    public void setUser(String string) {
        this.user_ = string;
    }

    public void setPassword(String string) {
        this.password_ = string;
    }

    public void close() throws ResourceException {
        super.close();
        try {
            if (this.conn_ != null) {
                this.conn_.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

