/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa;

import com.atomikos.datasource.RecoverableResource;
import com.atomikos.datasource.ResourceException;
import com.atomikos.datasource.ResourceTransaction;
import com.atomikos.datasource.TransactionalResource;
import com.atomikos.datasource.xa.DefaultXidFactory;
import com.atomikos.datasource.xa.OraXidFactory;
import com.atomikos.datasource.xa.SiblingMapper;
import com.atomikos.datasource.xa.XAResourceTransaction;
import com.atomikos.datasource.xa.XID;
import com.atomikos.datasource.xa.XidFactory;
import com.atomikos.diagnostics.Console;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RecoveryService;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.persistence.StateRecoveryManager;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public abstract class XATransactionalResource
implements TransactionalResource {
    protected XAResource xares_;
    protected String servername_;
    protected Hashtable recoveryMap_;
    protected Hashtable siblingmappers_;
    protected XidFactory xidFact_;
    private boolean closed_;
    private boolean weakCompare_;
    private boolean compareAlwaysTrue_;
    private String branchIdentifier_;

    public XATransactionalResource(String string) {
        this.servername_ = string;
        this.siblingmappers_ = new Hashtable();
        String string2 = "9223372036854775807";
        String string3 = string + string2;
        if (string3.getBytes().length > 64) {
            throw new RuntimeException("Max length of resource name exceeded: should be less than " + (64 - string2.getBytes().length));
        }
        this.xidFact_ = new DefaultXidFactory();
        this.closed_ = false;
        this.weakCompare_ = false;
        this.compareAlwaysTrue_ = false;
        this.branchIdentifier_ = string;
    }

    public XATransactionalResource(String string, XidFactory xidFactory) {
        this(string);
        this.xidFact_ = xidFactory;
    }

    protected abstract XAResource refreshXAConnection() throws ResourceException;

    public XidFactory getXidFactory() {
        return this.xidFact_;
    }

    protected void printMsg(String string, int n) {
        try {
            Console console = Configuration.getConsole();
            if (console != null) {
                console.println(string, n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSiblingMap(String string) {
        Hashtable hashtable = this.siblingmappers_;
        synchronized (hashtable) {
            this.siblingmappers_.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SiblingMapper getSiblingMap(String string) {
        Hashtable hashtable = this.siblingmappers_;
        synchronized (hashtable) {
            if (this.siblingmappers_.containsKey(string)) {
                return (SiblingMapper)this.siblingmappers_.get(string);
            }
            SiblingMapper siblingMapper = new SiblingMapper(this, string);
            this.siblingmappers_.put(string, siblingMapper);
            return siblingMapper;
        }
    }

    protected boolean needsRefresh() {
        boolean bl = true;
        try {
            if (this.xares_ != null) {
                this.xares_.isSameRM(this.xares_);
                bl = false;
            }
        }
        catch (XAException xAException) {
            Configuration.logDebug((String)(this.servername_ + ": XAResource needs refresh?"), (Exception)xAException);
        }
        return bl;
    }

    public void useWeakCompare(boolean bl) {
        this.weakCompare_ = bl;
    }

    public boolean usesWeakCompare() {
        return this.weakCompare_;
    }

    public void setAcceptAllXAResources(boolean bl) {
        this.compareAlwaysTrue_ = bl;
    }

    public boolean acceptsAllXAResources() {
        return this.compareAlwaysTrue_;
    }

    public boolean usesXAResource(XAResource xAResource) {
        if (this.acceptsAllXAResources()) {
            return true;
        }
        XAResource xAResource2 = this.getXAResource();
        if (xAResource2 == null) {
            return false;
        }
        boolean bl = false;
        if (!xAResource.getClass().getName().equals(xAResource2.getClass().getName())) {
            bl = false;
        } else {
            try {
                if (xAResource.isSameRM(xAResource2)) {
                    bl = true;
                } else if (this.usesWeakCompare()) {
                    bl = true;
                } else {
                    Configuration.logDebug((String)("XAResources claim to be different: " + xAResource + " and " + xAResource2));
                }
            }
            catch (XAException xAException) {
                Stack<XAException> stack = new Stack<XAException>();
                stack.push(xAException);
                throw new SysException("Error in XAResource comparison: " + xAException.getMessage(), stack);
            }
        }
        return bl;
    }

    public synchronized XAResource getXAResource() {
        if (this.needsRefresh()) {
            Configuration.logDebug((String)(this.servername_ + ": refreshing XAResource..."));
            this.xares_ = this.refreshXAConnection();
            Configuration.logWarning((String)(this.servername_ + ": refreshed XAResource"));
        }
        return this.xares_;
    }

    public ResourceTransaction getResourceTransaction(CompositeTransaction compositeTransaction) throws ResourceException, IllegalStateException {
        if (this.closed_) {
            throw new IllegalStateException("XATransactionResource already closed");
        }
        if (compositeTransaction == null) {
            return null;
        }
        Stack stack = compositeTransaction.getLineage();
        String string = null;
        if (stack == null || stack.isEmpty()) {
            string = compositeTransaction.getTid();
        } else {
            Stack stack2 = (Stack)stack.clone();
            while (!stack2.isEmpty()) {
                CompositeTransaction compositeTransaction2 = (CompositeTransaction)stack2.pop();
                if (!compositeTransaction2.isRoot()) continue;
                string = compositeTransaction2.getTid();
            }
        }
        return this.getSiblingMap(string).map(compositeTransaction);
    }

    private StateRecoveryManager getRecoveryManager() throws ResourceException {
        if (this.closed_) {
            throw new IllegalStateException("XATransactionResource already closed");
        }
        return null;
    }

    public String getName() {
        return this.servername_;
    }

    public void close() throws ResourceException {
        this.closed_ = true;
    }

    public boolean isClosed() throws ResourceException {
        return this.closed_;
    }

    public boolean isSameRM(RecoverableResource recoverableResource) throws ResourceException {
        if (recoverableResource == null || !(recoverableResource instanceof XATransactionalResource)) {
            return false;
        }
        XATransactionalResource xATransactionalResource = (XATransactionalResource)recoverableResource;
        if (xATransactionalResource.servername_ == null || this.servername_ == null) {
            return false;
        }
        return xATransactionalResource.servername_.equals(this.servername_);
    }

    public void setRecoveryService(RecoveryService recoveryService) throws ResourceException {
        if (recoveryService != null) {
            Configuration.logDebug((String)("Installing recovery service on resource " + this.getName()));
            this.branchIdentifier_ = recoveryService.getName();
            recoveryService.recover();
        }
    }

    public synchronized boolean recover(Participant participant) throws ResourceException {
        boolean bl = true;
        if (this.closed_) {
            throw new IllegalStateException("XATransactionResource already closed");
        }
        if (!(participant instanceof XAResourceTransaction)) {
            throw new ResourceException("Wrong argument class: " + participant.getClass().getName());
        }
        XAResource xAResource = this.getXAResource();
        if (xAResource == null) {
            Configuration.logWarning((String)("XATransactionalResource " + this.getName() + ": XAResource is NULL!"));
            return false;
        }
        XAResourceTransaction xAResourceTransaction = (XAResourceTransaction)participant;
        if (this.recoveryMap_ == null) {
            this.recover();
        }
        if (!this.recoveryMap_.containsKey(xAResourceTransaction.xid_)) {
            bl = false;
        }
        if (bl || this.getName().equals(xAResourceTransaction.resourcename_)) {
            xAResourceTransaction.setXAResource(this.getXAResource());
        }
        this.recoveryMap_.remove(xAResourceTransaction.xid_);
        return bl;
    }

    protected void recover() throws ResourceException {
        this.recoveryMap_ = new Hashtable();
        Xid[] xidArray = null;
        int n = 0x1000000;
        boolean bl = false;
        Stack<XAException> stack = new Stack<XAException>();
        Vector<XID> vector = new Vector<XID>();
        this.printMsg("recovery initiated for resource " + this.getName() + " with branchIdentifier " + this.branchIdentifier_, 3);
        do {
            try {
                xidArray = this.getXAResource().recover(n);
            }
            catch (NullPointerException nullPointerException) {
                if (this.xidFact_ instanceof OraXidFactory) {
                    this.printMsg("ORACLE NOT CONFIGURED FOR XA? PLEASE CONTACT YOUR DBA TO FIX THIS...", 1);
                }
                throw nullPointerException;
            }
            catch (XAException xAException) {
                Configuration.logWarning((String)"Error in recovery", (Exception)xAException);
                stack.push(xAException);
                throw new ResourceException("Error in recovery", stack);
            }
            n = 0;
            boolean bl2 = bl = xidArray == null || xidArray.length == 0;
            if (bl) continue;
            bl = true;
            for (int i = 0; i < xidArray.length; ++i) {
                XID xID = new XID(xidArray[i]);
                if (vector.contains(xID)) continue;
                this.printMsg("Resource " + this.servername_ + " inspecting XID: " + xID, 2);
                vector.addElement(xID);
                bl = false;
                String string = new String(xidArray[i].getBranchQualifier());
                if (string.startsWith(this.branchIdentifier_)) {
                    this.recoveryMap_.put(xID, new Object());
                    this.printMsg("Resource " + this.servername_ + " recovering XID: " + xID, 2);
                    continue;
                }
                this.printMsg("Resource " + this.servername_ + ": XID " + xID + " with branch " + string + " is not under my responsibility", 2);
            }
        } while (!bl);
        vector = null;
    }

    public void endRecovery() throws ResourceException {
        if (this.closed_) {
            throw new IllegalStateException("XATransactionResource already closed");
        }
        XAResource xAResource = this.getXAResource();
        if (xAResource == null) {
            return;
        }
        if (this.recoveryMap_ == null) {
            this.recover();
        }
        Enumeration enumeration = this.recoveryMap_.keys();
        while (enumeration.hasMoreElements()) {
            XID xID = (XID)enumeration.nextElement();
            try {
                xAResource.rollback(xID);
                this.printMsg("XAResource.rollback ( " + xID + " ) called " + "on resource " + this.servername_, 2);
            }
            catch (XAException xAException) {}
        }
        this.recoveryMap_ = null;
        this.printMsg("endRecovery() done for resource " + this.getName(), 3);
    }

    public void setXidFactory(XidFactory xidFactory) {
        this.xidFact_ = xidFactory;
    }

    protected Xid createXid(String string) {
        return this.getXidFactory().createXid(string, this.branchIdentifier_);
    }
}

