/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa;

import com.atomikos.datasource.RecoverableResource;
import com.atomikos.datasource.ResourceException;
import com.atomikos.datasource.ResourceTransaction;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.diagnostics.Console;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.StringHeuristicMessage;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TransactionControl;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.system.Configuration;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceTransaction
implements ResourceTransaction,
Externalizable,
Participant {
    static final long serialVersionUID = -8227293322090019196L;
    protected String tid_;
    protected String root_;
    private boolean isXaSuspended_;
    protected TxState state_;
    protected String resourcename_;
    protected transient Xid xid_;
    protected transient XATransactionalResource resource_;
    protected transient XAResource xaresource_;
    protected transient CompositeTransaction transaction_;
    protected Vector heuristicMessages_;
    protected transient boolean enlisted_;
    protected transient int timeout_;

    protected static String interpretErrorCode(String string, Xid xid, int n) {
        String string2 = "unkown";
        switch (n) {
            case -7: {
                string2 = "the XA resource has become unavailable";
                break;
            }
            case 100: {
                string2 = "the XA resource has rolled back for an unspecified reason";
                break;
            }
            case 101: {
                string2 = "the XA resource rolled back due to a communication failure";
                break;
            }
            case 102: {
                string2 = "the XA resource has rolled back because of a deadlock";
                break;
            }
            case 103: {
                string2 = "the XA resource has rolled back due to a constraint violation";
                break;
            }
            case 104: {
                string2 = "the XA resource has rolled back for an unknown reason";
                break;
            }
            case 105: {
                string2 = "the XA resource has rolled back because it did not expect this command in the current context";
                break;
            }
            case 106: {
                string2 = "the XA resource has rolled back because the transaction took too long";
                break;
            }
            case 107: {
                string2 = "the XA resource has rolled back for a temporary reason - the transaction can be retried later";
                break;
            }
            case 9: {
                string2 = "XA resume attempted in a different place from where suspend happened";
                break;
            }
            case 8: {
                string2 = "the XA resource may have heuristically completed the transaction";
                break;
            }
            case 7: {
                string2 = "the XA resource has heuristically committed";
                break;
            }
            case 6: {
                string2 = "the XA resource has heuristically rolled back";
                break;
            }
            case 5: {
                string2 = "the XA resource has heuristically committed some parts and rolled back other parts";
                break;
            }
            case 4: {
                string2 = "the XA command had no effect and may be retried";
                break;
            }
            case 3: {
                string2 = "the XA resource had no updates to perform for this transaction";
                break;
            }
            case -3: {
                string2 = "the XA resource detected an internal error";
                break;
            }
            case -4: {
                string2 = "the supplied XID is invalid for this XA resource";
                break;
            }
            case -5: {
                string2 = "invalid arguments were given for the XA operation";
                break;
            }
            case -6: {
                string2 = "the XA resource did not expect this command in the current context";
                break;
            }
            case -8: {
                string2 = "the supplied XID already exists in this XA resource";
                break;
            }
            case -9: {
                string2 = "the XA resource is currently involved in a local (non-XA) transaction";
                break;
            }
            default: {
                string2 = "unknown";
            }
        }
        return string + " for XID " + xid.toString() + " raised " + n + ": " + string2;
    }

    public XAResourceTransaction() {
    }

    XAResourceTransaction(XATransactionalResource xATransactionalResource, CompositeTransaction compositeTransaction, String string) {
        this.resource_ = xATransactionalResource;
        this.transaction_ = compositeTransaction;
        TransactionControl transactionControl = compositeTransaction.getTransactionControl();
        if (transactionControl != null) {
            this.timeout_ = (int)compositeTransaction.getTransactionControl().getTimeout() / 1000;
        }
        this.tid_ = compositeTransaction.getTid();
        this.root_ = string;
        this.resourcename_ = xATransactionalResource.getName();
        this.xid_ = this.resource_.createXid(this.tid_);
        this.state_ = TxState.ACTIVE;
        this.heuristicMessages_ = new Vector();
        this.isXaSuspended_ = false;
        this.enlisted_ = false;
        this.addHeuristicMessage((HeuristicMessage)new StringHeuristicMessage("XA: " + xATransactionalResource.getName() + " Xid: " + this.xid_.toString()));
    }

    protected void testOrRefreshXAResourceFor2PC() {
        try {
            if (this.xaresource_ != null) {
                this.xaresource_.isSameRM(this.xaresource_);
            }
        }
        catch (XAException xAException) {
            Configuration.logDebug((String)(this.resourcename_ + ": XAResource needs refresh"), (Exception)xAException);
            this.xaresource_ = this.resource_.getXAResource();
        }
    }

    protected void printMsg(String string, int n) {
        try {
            Console console = Configuration.getConsole();
            if (console != null) {
                console.println(string, n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void terminateInResource() {
        if (this.resource_ != null) {
            this.resource_.removeSiblingMap(this.root_);
        }
    }

    protected boolean isValid() {
        return !this.state_.equals((Object)TxState.MARKED_ABORT);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.xid_);
        objectOutput.writeObject(this.tid_);
        objectOutput.writeObject(this.root_);
        objectOutput.writeObject(this.state_);
        objectOutput.writeObject(this.heuristicMessages_.clone());
        objectOutput.writeObject(this.resourcename_);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.xid_ = (Xid)objectInput.readObject();
        this.tid_ = (String)objectInput.readObject();
        this.root_ = (String)objectInput.readObject();
        this.state_ = (TxState)objectInput.readObject();
        this.heuristicMessages_ = (Vector)objectInput.readObject();
        this.resourcename_ = (String)objectInput.readObject();
    }

    public String getTid() {
        return this.tid_;
    }

    public void addCompensationContext(Dictionary dictionary) throws IllegalStateException {
    }

    public void addHeuristicMessage(HeuristicMessage heuristicMessage) throws IllegalStateException {
        this.heuristicMessages_.addElement(heuristicMessage);
    }

    public HeuristicMessage[] getHeuristicMessages() {
        HeuristicMessage[] heuristicMessageArray = new HeuristicMessage[1];
        return this.heuristicMessages_.toArray(heuristicMessageArray);
    }

    public Dictionary getCompensationContext() {
        return null;
    }

    public synchronized void suspend() throws ResourceException {
        Stack<XAException> stack = new Stack<XAException>();
        if (this.state_.equals((Object)TxState.ACTIVE)) {
            try {
                this.xaresource_.end(this.xid_, 0x4000000);
                this.printMsg("XAResource.end ( " + this.xid_ + " , XAResource.TMSUCCESS ) called " + "on resource " + this.resourcename_ + " represented by XAResource instance " + this.xaresource_, 2);
            }
            catch (XAException xAException) {
                stack.push(xAException);
                String string = XAResourceTransaction.interpretErrorCode("end", this.xid_, xAException.errorCode);
                Configuration.logDebug((String)string, (Exception)xAException);
                throw new ResourceException(string, stack);
            }
            this.state_ = TxState.LOCALLY_DONE;
        }
    }

    public synchronized void resume() throws ResourceException {
        int n = 0;
        Stack<XAException> stack = new Stack<XAException>();
        String string = "";
        if (this.state_.equals((Object)TxState.LOCALLY_DONE)) {
            n = 0x200000;
            string = "XAResource.TMJOIN";
        } else if (!this.enlisted_) {
            n = 0;
            string = "XAResource.TMNOFLAGS";
        } else {
            throw new IllegalStateException("Wrong state for resume: " + this.state_);
        }
        try {
            this.xaresource_.start(this.xid_, n);
            this.printMsg("XAResource.start ( " + this.xid_ + " , " + string + " ) called " + "on resource " + this.resourcename_ + " represented by XAResource instance " + this.xaresource_, 2);
        }
        catch (XAException xAException) {
            String string2 = XAResourceTransaction.interpretErrorCode("resume", this.xid_, xAException.errorCode);
            Configuration.logWarning((String)string2, (Exception)xAException);
            stack.push(xAException);
            throw new ResourceException(string2, stack);
        }
        this.state_ = TxState.ACTIVE;
        this.enlisted_ = true;
    }

    public void setCascadeList(Dictionary dictionary) throws SysException {
    }

    public Object getState() {
        return this.state_;
    }

    public boolean recover() throws SysException {
        boolean bl = false;
        Enumeration enumeration = Configuration.getResources();
        while (enumeration.hasMoreElements()) {
            RecoverableResource recoverableResource = (RecoverableResource)enumeration.nextElement();
            if (!recoverableResource.recover((Participant)this)) continue;
            bl = true;
        }
        this.enlisted_ = true;
        return bl;
    }

    public void setGlobalSiblingCount(int n) {
    }

    public synchronized void forget() {
        this.terminateInResource();
        try {
            if (this.xaresource_ != null) {
                this.xaresource_.forget(this.xid_);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.state_ = TxState.TERMINATED;
    }

    public synchronized int prepare() throws RollbackException, HeurHazardException, HeurMixedException, SysException {
        int n = 0;
        Stack<XAException> stack = new Stack<XAException>();
        this.terminateInResource();
        if (TxState.ACTIVE.equals((Object)this.state_)) {
            this.suspend();
        }
        if (this.state_.equals((Object)TxState.IN_DOUBT)) {
            return 0;
        }
        if (!this.state_.equals((Object)TxState.LOCALLY_DONE)) {
            throw new SysException("Wrong state for prepare: " + this.state_);
        }
        try {
            this.testOrRefreshXAResourceFor2PC();
            this.printMsg("About to call prepare on XAResource instance: " + this.xaresource_, 3);
            n = this.xaresource_.prepare(this.xid_);
        }
        catch (XAException xAException) {
            String string = XAResourceTransaction.interpretErrorCode("prepare", this.xid_, xAException.errorCode);
            Configuration.logDebug((String)string, (Exception)xAException);
            if (100 <= xAException.errorCode && xAException.errorCode <= 107) {
                throw new RollbackException(string);
            }
            stack.push(xAException);
            throw new SysException(string, stack);
        }
        this.state_ = TxState.IN_DOUBT;
        if (n == 3) {
            this.printMsg("XAResource.prepare ( " + this.xid_ + " ) returning XAResource.XA_RDONLY " + "on resource " + this.resourcename_ + " represented by XAResource instance " + this.xaresource_, 2);
            return 0;
        }
        this.printMsg("XAResource.prepare ( " + this.xid_ + " ) returning OK " + "on resource " + this.resourcename_ + " represented by XAResource instance " + this.xaresource_, 2);
        return 1;
    }

    public synchronized HeuristicMessage[] rollback() throws HeurCommitException, HeurMixedException, HeurHazardException, SysException {
        Stack<Throwable> stack = new Stack<Throwable>();
        this.terminateInResource();
        if (!this.enlisted_) {
            return null;
        }
        if (this.state_.equals((Object)TxState.TERMINATED)) {
            return this.getHeuristicMessages();
        }
        if (this.state_.equals((Object)TxState.HEUR_HAZARD)) {
            throw new HeurHazardException(this.getHeuristicMessages());
        }
        if (this.state_.equals((Object)TxState.HEUR_MIXED)) {
            throw new HeurMixedException(this.getHeuristicMessages());
        }
        if (this.state_.equals((Object)TxState.HEUR_COMMITTED)) {
            throw new HeurCommitException(this.getHeuristicMessages());
        }
        if (this.xaresource_ == null) {
            Configuration.logWarning((String)("XAResourceTransaction " + this.getXid() + ": no XAResource to rollback - the required resource is probably not yet intialized?"));
            throw new HeurHazardException(this.getHeuristicMessages());
        }
        try {
            if (this.state_.equals((Object)TxState.ACTIVE)) {
                this.suspend();
            }
            this.testOrRefreshXAResourceFor2PC();
            this.printMsg("About to call rollback on XAResource instance: " + this.xaresource_, 3);
            this.xaresource_.rollback(this.xid_);
            this.printMsg("XAResource.rollback ( " + this.xid_ + " ) called " + "on resource " + this.resourcename_ + " represented by XAResource instance " + this.xaresource_, 2);
        }
        catch (ResourceException resourceException) {
            stack.push(resourceException);
            throw new SysException("Error in rollback: " + resourceException.getMessage(), stack);
        }
        catch (XAException xAException) {
            String string = XAResourceTransaction.interpretErrorCode("rollback", this.xid_, xAException.errorCode);
            if (100 <= xAException.errorCode && xAException.errorCode <= 107) {
                Configuration.logDebug((String)string);
            }
            Configuration.logWarning((String)string, (Exception)xAException);
            switch (xAException.errorCode) {
                case 8: {
                    this.state_ = TxState.HEUR_HAZARD;
                    throw new HeurHazardException(this.getHeuristicMessages());
                }
                case 5: {
                    this.state_ = TxState.HEUR_MIXED;
                    throw new HeurMixedException(this.getHeuristicMessages());
                }
                case 7: {
                    this.state_ = TxState.HEUR_COMMITTED;
                    throw new HeurCommitException(this.getHeuristicMessages());
                }
                case 6: {
                    this.forget();
                    break;
                }
                case -4: {
                    this.printMsg("XAResource.rollback: invalid Xid - already rolled back in resource?", 3);
                    this.state_ = TxState.TERMINATED;
                    break;
                }
                default: {
                    stack.push(xAException);
                    throw new SysException(string, stack);
                }
            }
        }
        this.state_ = TxState.TERMINATED;
        return this.getHeuristicMessages();
    }

    public synchronized HeuristicMessage[] commit(boolean bl) throws HeurRollbackException, HeurHazardException, HeurMixedException, RollbackException, SysException {
        Stack<XAException> stack = new Stack<XAException>();
        this.terminateInResource();
        if (this.state_.equals((Object)TxState.MARKED_ABORT)) {
            throw new SysException("Marked for rollback only");
        }
        if (this.state_.equals((Object)TxState.TERMINATED)) {
            return this.getHeuristicMessages();
        }
        if (this.state_.equals((Object)TxState.HEUR_HAZARD)) {
            throw new HeurHazardException(this.getHeuristicMessages());
        }
        if (this.state_.equals((Object)TxState.HEUR_MIXED)) {
            throw new HeurMixedException(this.getHeuristicMessages());
        }
        if (this.state_.equals((Object)TxState.HEUR_ABORTED)) {
            throw new HeurRollbackException(this.getHeuristicMessages());
        }
        if (this.xaresource_ == null) {
            Configuration.logWarning((String)("XAResourceTransaction " + this.getXid() + ": no XAResource to commit - the required resource is probably not yet intialized?"));
            throw new HeurHazardException(this.getHeuristicMessages());
        }
        try {
            if (TxState.ACTIVE.equals((Object)this.state_)) {
                this.suspend();
            }
        }
        catch (ResourceException resourceException) {
            throw new RollbackException(resourceException.getMessage());
        }
        if (!this.state_.equals((Object)TxState.LOCALLY_DONE) && !this.state_.equals((Object)TxState.IN_DOUBT)) {
            throw new SysException("Wrong state for commit: " + this.state_);
        }
        try {
            this.testOrRefreshXAResourceFor2PC();
            this.printMsg("About to call commit on XAResource instance: " + this.xaresource_, 3);
            this.xaresource_.commit(this.xid_, bl);
            this.printMsg("XAResource.commit ( " + this.xid_ + " , " + bl + " ) called " + "on resource " + this.resourcename_ + " represented by XAResource instance " + this.xaresource_, 2);
        }
        catch (XAException xAException) {
            String string = XAResourceTransaction.interpretErrorCode("commit", this.xid_, xAException.errorCode);
            Configuration.logWarning((String)string, (Exception)xAException);
            if (100 <= xAException.errorCode && xAException.errorCode <= 107) {
                stack.push(xAException);
                if (!bl) {
                    throw new SysException(string, stack);
                }
                throw new RollbackException("Already rolled back in resource.");
            }
            switch (xAException.errorCode) {
                case 8: {
                    this.state_ = TxState.HEUR_HAZARD;
                    throw new HeurHazardException(this.getHeuristicMessages());
                }
                case 5: {
                    this.state_ = TxState.HEUR_MIXED;
                    throw new HeurMixedException(this.getHeuristicMessages());
                }
                case 7: {
                    this.forget();
                    break;
                }
                case 6: {
                    this.state_ = TxState.HEUR_ABORTED;
                    throw new HeurRollbackException(this.getHeuristicMessages());
                }
                case -4: {
                    if (!bl) {
                        this.printMsg("XAResource.commit: invalid Xid - transaction already committed in resource?", 1);
                        this.state_ = TxState.TERMINATED;
                        break;
                    }
                }
                default: {
                    stack.push(xAException);
                    throw new SysException(string, stack);
                }
            }
        }
        this.state_ = TxState.TERMINATED;
        return this.getHeuristicMessages();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof XAResourceTransaction)) {
            return false;
        }
        XAResourceTransaction xAResourceTransaction = (XAResourceTransaction)object;
        return this.xid_.equals(xAResourceTransaction.xid_);
    }

    public int hashCode() {
        return this.xid_.toString().hashCode();
    }

    public String toString() {
        return this.xid_.toString();
    }

    public Xid getXid() {
        return this.xid_;
    }

    public void setXAResource(XAResource xAResource) {
        Configuration.logDebug((String)("XAResourceTransaction " + this.getXid() + ": about to switch to XAResource " + xAResource));
        this.xaresource_ = xAResource;
        try {
            this.xaresource_.setTransactionTimeout(this.timeout_);
        }
        catch (XAException xAException) {
            String string = XAResourceTransaction.interpretErrorCode("setTransactionTimeout", this.xid_, xAException.errorCode);
            Configuration.logWarning((String)string, (Exception)xAException);
        }
        Configuration.logDebug((String)("XAResourceTransaction " + this.getXid() + ": switched to XAResource " + xAResource));
    }

    public void xaSuspend() throws XAException {
        this.xaresource_.end(this.xid_, 0x2000000);
        this.printMsg("XAResource.suspend ( " + this.xid_ + " , XAResource.TMSUSPEND ) called " + "on resource " + this.resourcename_ + " represented by XAResource instance " + this.xaresource_, 2);
        this.isXaSuspended_ = true;
    }

    public void xaResume() throws XAException {
        this.xaresource_.start(this.xid_, 0x8000000);
        this.printMsg("XAResource.start ( " + this.xid_ + " , XAResource.TMRESUME ) called " + "on resource " + this.resourcename_ + " represented by XAResource instance " + this.xaresource_, 2);
        this.isXaSuspended_ = false;
    }

    public boolean isXaSuspended() {
        return this.isXaSuspended_;
    }

    public boolean isActive() {
        return this.state_.equals((Object)TxState.ACTIVE);
    }

    public String getURI() {
        return null;
    }
}

