/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa;

import java.io.PrintWriter;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class LoggingXAResource
implements XAResource {
    private PrintWriter writer_;
    private XAResource xares_;

    public LoggingXAResource(XAResource xAResource, PrintWriter printWriter) {
        this.xares_ = xAResource;
        this.writer_ = printWriter;
    }

    private void log(String string, XAException xAException) {
        if (this.writer_ != null) {
            this.writer_.println("XAResource: " + string + ": " + xAException.toString() + " errorCode " + xAException.errorCode);
        }
    }

    private void log(String string) {
        if (this.writer_ != null) {
            this.writer_.println("XAResource: " + string);
        }
    }

    public Xid[] recover(int n) throws XAException {
        Xid[] xidArray = null;
        try {
            this.log("Enter recover");
            xidArray = this.xares_.recover(n);
            this.log("Exit recover");
        }
        catch (XAException xAException) {
            this.log("Error in recover", xAException);
            throw xAException;
        }
        return xidArray;
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        boolean bl = false;
        try {
            this.log("Enter setTransactionTimeout");
            bl = this.xares_.setTransactionTimeout(n);
            this.log("Exit setTransactionTimeout with return value " + bl);
        }
        catch (XAException xAException) {
            this.log("Error in setTransactionTimeout", xAException);
            throw xAException;
        }
        return bl;
    }

    public int getTransactionTimeout() throws XAException {
        int n = -1;
        try {
            this.log("Enter getTransactionTimeout");
            n = this.xares_.getTransactionTimeout();
            this.log("Exit getTransactionTimeout with return value " + n);
        }
        catch (XAException xAException) {
            this.log("Error in getTransactionTimeout", xAException);
            throw xAException;
        }
        return n;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        boolean bl = false;
        try {
            this.log("Enter isSameRM");
            bl = this.xares_.isSameRM(xAResource);
            this.log("Exit isSameRM with return value " + bl);
        }
        catch (XAException xAException) {
            this.log("Error in isSameRM", xAException);
            throw xAException;
        }
        return bl;
    }

    public void start(Xid xid, int n) throws XAException {
        try {
            this.log("Enter start for xid " + xid.toString());
            this.xares_.start(xid, n);
            this.log("Exit start");
        }
        catch (XAException xAException) {
            this.log("Error in start", xAException);
            throw xAException;
        }
    }

    public void end(Xid xid, int n) throws XAException {
        try {
            this.log("Enter end for xid " + xid.toString());
            this.xares_.end(xid, n);
            this.log("Exit end");
        }
        catch (XAException xAException) {
            this.log("Error in end", xAException);
            throw xAException;
        }
    }

    public int prepare(Xid xid) throws XAException {
        int n = -1;
        try {
            this.log("Enter prepare for xid " + xid.toString());
            n = this.xares_.prepare(xid);
            this.log("Exit prepare with return value " + n);
        }
        catch (XAException xAException) {
            this.log("Error in prepare", xAException);
            throw xAException;
        }
        return n;
    }

    public void rollback(Xid xid) throws XAException {
        try {
            this.log("Enter rollback for xid " + xid.toString());
            this.xares_.rollback(xid);
            this.log("Exit rollback");
        }
        catch (XAException xAException) {
            this.log("Error in rollback", xAException);
            throw xAException;
        }
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        try {
            this.log("Enter commit for xid " + xid.toString());
            this.xares_.commit(xid, bl);
            this.log("Exit commit");
        }
        catch (XAException xAException) {
            this.log("Error in commit", xAException);
            throw xAException;
        }
    }

    public void forget(Xid xid) throws XAException {
        try {
            this.log("Enter forget for xid " + xid.toString());
            this.xares_.forget(xid);
            this.log("Exit forget");
        }
        catch (XAException xAException) {
            this.log("Error in forget", xAException);
            throw xAException;
        }
    }
}

