/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms.internal;

import com.atomikos.datasource.pool.AbstractXPooledConnection;
import com.atomikos.datasource.pool.ConnectionPoolProperties;
import com.atomikos.datasource.pool.CreateConnectionException;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.datasource.xa.session.SessionHandleStateChangeListener;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.config.Configuration;
import com.atomikos.icatch.jta.TransactionManagerImp;
import com.atomikos.jms.internal.AtomikosJmsConnectionProxy;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.lang.reflect.Proxy;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.XAConnection;

public class AtomikosPooledJmsConnection
extends AbstractXPooledConnection<Connection>
implements SessionHandleStateChangeListener {
    private static final Logger LOGGER = LoggerFactory.createLogger(AtomikosPooledJmsConnection.class);
    private XAConnection xaConnection;
    private XATransactionalResource jmsTransactionalResource;
    private Connection currentProxy;
    private ConnectionPoolProperties props;
    private boolean erroneous;
    private boolean ignoreSessionTransactedFlag;

    public AtomikosPooledJmsConnection(boolean ignoreSessionTransactedFlag, XAConnection xac, XATransactionalResource jmsTransactionalResource, ConnectionPoolProperties props) {
        super(props);
        this.jmsTransactionalResource = jmsTransactionalResource;
        this.xaConnection = xac;
        this.props = props;
        this.erroneous = false;
        this.ignoreSessionTransactedFlag = ignoreSessionTransactedFlag;
    }

    protected Connection doCreateConnectionProxy() throws CreateConnectionException {
        this.currentProxy = AtomikosJmsConnectionProxy.newInstance(this.ignoreSessionTransactedFlag, this.xaConnection, this.jmsTransactionalResource, this, this.props);
        return this.currentProxy;
    }

    protected void testUnderlyingConnection() throws CreateConnectionException {
        if (this.isErroneous()) {
            throw new CreateConnectionException((Object)((Object)this) + ": connection is erroneous");
        }
        if (this.maxLifetimeExceeded()) {
            throw new CreateConnectionException((Object)((Object)this) + ": connection too old - will be replaced");
        }
    }

    public void doDestroy() {
        if (this.xaConnection != null) {
            try {
                this.xaConnection.close();
            }
            catch (JMSException ex) {
                LOGGER.logWarning((Object)((Object)this) + ": error closing XAConnection: ", (Throwable)ex);
            }
        }
        this.xaConnection = null;
    }

    public synchronized boolean isAvailable() {
        boolean ret = true;
        if (this.currentProxy != null) {
            AtomikosJmsConnectionProxy proxy = (AtomikosJmsConnectionProxy)((Object)Proxy.getInvocationHandler(this.currentProxy));
            ret = proxy.isAvailable();
        }
        return ret;
    }

    public synchronized boolean isErroneous() {
        boolean ret = this.erroneous;
        if (this.currentProxy != null) {
            AtomikosJmsConnectionProxy proxy = (AtomikosJmsConnectionProxy)((Object)Proxy.getInvocationHandler(this.currentProxy));
            ret = ret || proxy.isErroneous();
        }
        return ret;
    }

    public synchronized boolean isInTransaction(CompositeTransaction ct) {
        boolean ret = false;
        if (this.currentProxy != null) {
            AtomikosJmsConnectionProxy proxy = (AtomikosJmsConnectionProxy)((Object)Proxy.getInvocationHandler(this.currentProxy));
            ret = proxy.isInTransaction(ct);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTerminated() {
        boolean fireTerminatedEvent = false;
        AtomikosJmsConnectionProxy proxy = null;
        AtomikosPooledJmsConnection atomikosPooledJmsConnection = this;
        synchronized (atomikosPooledJmsConnection) {
            fireTerminatedEvent = this.isAvailable();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace((Object)((Object)this) + ": a session has terminated, is connection now available ? " + fireTerminatedEvent);
            }
            if (this.currentProxy != null && (proxy = (AtomikosJmsConnectionProxy)((Object)Proxy.getInvocationHandler(this.currentProxy))).isErroneous()) {
                this.erroneous = true;
            }
        }
        if (fireTerminatedEvent) {
            if (proxy != null) {
                proxy.closeAllPendingSessions();
            }
            this.fireOnXPooledConnectionTerminated();
        }
    }

    public boolean canBeRecycledForCallingThread() {
        CompositeTransactionManager tm;
        CompositeTransaction current;
        boolean ret = false;
        if (this.currentProxy != null && (current = (tm = Configuration.getCompositeTransactionManager()).getCompositeTransaction()) != null && TransactionManagerImp.isJtaTransaction((CompositeTransaction)current)) {
            AtomikosJmsConnectionProxy proxy = (AtomikosJmsConnectionProxy)((Object)Proxy.getInvocationHandler(this.currentProxy));
            ret = proxy.isInactiveInTransaction(current);
        }
        return ret;
    }

    public String toString() {
        return "atomikosPooledJmsConnection for resource " + this.jmsTransactionalResource.getName();
    }
}

