/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.beans.PropertyUtils;
import com.atomikos.datasource.pool.Reapable;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.datasource.xa.session.SessionHandleState;
import com.atomikos.datasource.xa.session.SessionHandleStateChangeListener;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.jms.AbstractJmsSessionProxy;
import com.atomikos.jms.AtomikosJmsMessageConsumerProxy;
import com.atomikos.jms.AtomikosJmsMessageProducerProxy;
import com.atomikos.jms.AtomikosJmsTopicSubscriberProxy;
import com.atomikos.jms.ConsumerProducerSupport;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.util.ClassLoadingHelper;
import com.atomikos.util.DynamicProxy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TopicSubscriber;
import javax.jms.TransactionInProgressException;
import javax.jms.XASession;

class AtomikosJmsXaSessionProxy
extends AbstractJmsSessionProxy
implements SessionHandleStateChangeListener {
    private static final Logger LOGGER = LoggerFactory.createLogger(AtomikosJmsXaSessionProxy.class);
    private static final List<String> PRODUCER_CONSUMER_METHODS = Arrays.asList("createConsumer", "createProducer", "createDurableSubscriber");
    private static final List<String> SESSION_TRANSACTION_METHODS = Arrays.asList("commit", "rollback");
    private static Class<?>[] MINIMUM_SET_OF_INTERFACES = new Class[]{Reapable.class, DynamicProxy.class, Session.class};
    private static final String CLOSE_METHOD = "close";
    private XASession delegate;
    private boolean closed = false;
    private SessionHandleState state;
    private XATransactionalResource jmsTransactionalResource;

    public static Object newInstance(XASession s, XATransactionalResource jmsTransactionalResource, SessionHandleStateChangeListener pooledConnection, SessionHandleStateChangeListener connectionProxy) throws JMSException {
        AtomikosJmsXaSessionProxy proxy = new AtomikosJmsXaSessionProxy(s, jmsTransactionalResource, pooledConnection, connectionProxy);
        Set interfaces = PropertyUtils.getAllImplementedInterfaces(s.getClass());
        interfaces.add(DynamicProxy.class);
        Class[] interfaceClasses = interfaces.toArray(new Class[0]);
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        classLoaders.add(Thread.currentThread().getContextClassLoader());
        classLoaders.add(s.getClass().getClassLoader());
        classLoaders.add(AtomikosJmsXaSessionProxy.class.getClassLoader());
        return (Session)ClassLoadingHelper.newProxyInstance(classLoaders, (Class[])MINIMUM_SET_OF_INTERFACES, (Class[])interfaceClasses, (InvocationHandler)proxy);
    }

    private AtomikosJmsXaSessionProxy(XASession s, XATransactionalResource jmsTransactionalResource, SessionHandleStateChangeListener pooledConnection, SessionHandleStateChangeListener connectionProxy) {
        this.delegate = s;
        this.jmsTransactionalResource = jmsTransactionalResource;
        this.state = new SessionHandleState(jmsTransactionalResource, s.getXAResource());
        this.state.registerSessionHandleStateChangeListener(pooledConnection);
        this.state.registerSessionHandleStateChangeListener(connectionProxy);
        this.state.registerSessionHandleStateChangeListener((SessionHandleStateChangeListener)this);
        this.state.notifySessionBorrowed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws JMSException {
        String methodName = method.getName();
        if (methodName.equals("getInvocationHandler")) {
            return this;
        }
        AtomikosJmsXaSessionProxy atomikosJmsXaSessionProxy = this;
        synchronized (atomikosJmsXaSessionProxy) {
            if (this.closed) {
                if (!methodName.equals(CLOSE_METHOD)) {
                    String msg = "Session was closed already - calling " + methodName + " is no longer allowed.";
                    LOGGER.logWarning(this + ": " + msg);
                    throw new IllegalStateException(msg);
                }
                return null;
            }
            if (SESSION_TRANSACTION_METHODS.contains(methodName)) {
                String msg = "Calling commit/rollback is not allowed on a managed session!";
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.logDebug(this + ": " + msg);
                }
                throw new TransactionInProgressException(msg);
            }
            if (CLOSE_METHOD.equals(methodName)) {
                this.state.notifySessionClosed();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.logDebug(this + ": closing session " + this + " - is terminated ? " + this.state.isTerminated());
                }
                if (this.state.isTerminated()) {
                    this.destroy(true);
                } else {
                    this.destroy(false);
                }
                return null;
            }
            if (PRODUCER_CONSUMER_METHODS.contains(methodName)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.logDebug(this + ": calling " + methodName + " on JMS driver session " + this.delegate);
                }
                ConsumerProducerSupport producerConsumerProxy = null;
                if ("createConsumer".equals(methodName)) {
                    MessageConsumer vendorConsumer = null;
                    try {
                        vendorConsumer = (MessageConsumer)method.invoke((Object)this.delegate, args);
                    }
                    catch (Exception e) {
                        String msg = "Failed to create MessageConsumer: " + e.getMessage();
                        this.state.notifySessionErrorOccurred();
                        this.convertProxyError(e, msg);
                    }
                    producerConsumerProxy = new AtomikosJmsMessageConsumerProxy(vendorConsumer, this.state);
                } else if ("createProducer".equals(methodName)) {
                    MessageProducer vendorProducer = null;
                    try {
                        vendorProducer = (MessageProducer)method.invoke((Object)this.delegate, args);
                    }
                    catch (Exception e) {
                        String msg = "Failed to create MessageProducer: " + e.getMessage();
                        this.state.notifySessionErrorOccurred();
                        this.convertProxyError(e, msg);
                    }
                    producerConsumerProxy = new AtomikosJmsMessageProducerProxy(vendorProducer, this.state);
                } else if ("createDurableSubscriber".equals(methodName)) {
                    TopicSubscriber vendorSubscriber = null;
                    try {
                        vendorSubscriber = (TopicSubscriber)method.invoke((Object)this.delegate, args);
                    }
                    catch (Exception e) {
                        String msg = "Failed to create durable TopicSubscriber: " + e.getMessage();
                        this.state.notifySessionErrorOccurred();
                        this.convertProxyError(e, msg);
                    }
                    producerConsumerProxy = new AtomikosJmsTopicSubscriberProxy(vendorSubscriber, this.state);
                }
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.logTrace(this + ": " + methodName + " returning " + producerConsumerProxy);
                }
                return producerConsumerProxy;
            }
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.logDebug(this + ": calling " + methodName + " on JMS driver session...");
                }
                Object ret = method.invoke((Object)this.delegate, args);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.logTrace(this + ": " + methodName + " returning " + ret);
                }
                return ret;
            }
            catch (Exception ex) {
                String msg = "Error delegating call to " + methodName + " on JMS driver";
                this.state.notifySessionErrorOccurred();
                this.convertProxyError(ex, msg);
            }
        }
        return null;
    }

    protected void destroy(boolean closeXaSession) {
        if (closeXaSession) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace(this + ": closing underlying vendor session " + this);
            }
            try {
                this.delegate.close();
            }
            catch (JMSException e) {
                LOGGER.logWarning(this + ": could not close underlying vendor session", (Throwable)e);
            }
        }
        this.closed = true;
    }

    @Override
    protected boolean isAvailable() {
        boolean ret = false;
        if (this.state != null) {
            ret = this.state.isTerminated();
        }
        return ret;
    }

    @Override
    protected boolean isErroneous() {
        boolean ret = false;
        if (this.state != null) {
            ret = this.state.isErroneous();
        }
        return ret;
    }

    @Override
    protected boolean isInTransaction(CompositeTransaction ct) {
        boolean ret = false;
        if (this.state != null) {
            ret = this.state.isActiveInTransaction(ct);
        }
        return ret;
    }

    @Override
    protected boolean isInactiveTransaction(CompositeTransaction ct) {
        boolean ret = false;
        if (this.state != null) {
            ret = this.state.isInactiveInTransaction(ct);
        }
        return ret;
    }

    public void onTerminated() {
        this.destroy(true);
    }

    public String toString() {
        return "atomikos xa session proxy for resource " + this.jmsTransactionalResource.getName();
    }
}

