/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.datasource.pool.ConnectionFactory;
import com.atomikos.datasource.pool.CreateConnectionException;
import com.atomikos.datasource.pool.XPooledConnection;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.datasource.xa.jms.JmsTransactionalResource;
import com.atomikos.jms.AtomikosConnectionFactoryBean;
import com.atomikos.jms.AtomikosPooledJmsConnection;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;

class AtomikosJmsXAConnectionFactory
implements ConnectionFactory {
    private XAConnectionFactory xaConnectionFactory;
    private JmsTransactionalResource jmsTransactionalResource;
    private AtomikosConnectionFactoryBean atomikosConnectionFactory;

    public AtomikosJmsXAConnectionFactory(XAConnectionFactory xaConnectionFactory, JmsTransactionalResource jmsTransactionalResource, AtomikosConnectionFactoryBean atomikosConnectionFactory) {
        this.xaConnectionFactory = xaConnectionFactory;
        this.jmsTransactionalResource = jmsTransactionalResource;
        this.atomikosConnectionFactory = atomikosConnectionFactory;
    }

    public XPooledConnection createPooledConnection() throws CreateConnectionException {
        try {
            XAConnection xac = this.xaConnectionFactory.createXAConnection();
            return new AtomikosPooledJmsConnection(this.atomikosConnectionFactory.getIgnoreSessionTransactedFlag(), xac, (XATransactionalResource)this.jmsTransactionalResource, this.atomikosConnectionFactory);
        }
        catch (JMSException ex) {
            throw new CreateConnectionException("error creating JMS connection", (Exception)((Object)ex));
        }
    }
}

