/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.config;

import com.atomikos.datasource.RecoverableResource;
import com.atomikos.datasource.ResourceException;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.RecoveryService;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TransactionService;
import com.atomikos.icatch.TransactionServicePlugin;
import com.atomikos.icatch.provider.Assembler;
import com.atomikos.icatch.provider.ConfigProperties;
import com.atomikos.icatch.provider.TransactionServiceProvider;
import com.atomikos.recovery.RecoveryLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Vector;

public final class Configuration {
    private static CompositeTransactionManager ctxmgr_ = null;
    private static Hashtable resources_ = new Hashtable();
    private static Vector<RecoverableResource> resourceList_ = new Vector();
    private static RecoveryService recoveryService_;
    private static TransactionServiceProvider service_;
    private static Vector<TransactionServicePlugin> tsListenersList_;
    private static List shutdownHooks_;
    private static Assembler assembler;
    private static ConfigProperties configProperties;

    private static void purgeResources() {
        Collection<RecoverableResource> resources = Configuration.getResources();
        for (RecoverableResource res : resources) {
            if (!res.isClosed()) continue;
            Configuration.removeResource(res.getName());
        }
    }

    private Configuration() {
    }

    private static void addAllTransactionServicePluginServicesFromClasspath() {
        ServiceLoader<TransactionServicePlugin> loader = ServiceLoader.load(TransactionServicePlugin.class, Configuration.class.getClassLoader());
        for (TransactionServicePlugin l : loader) {
            Configuration.registerTransactionServicePlugin(l);
        }
    }

    private static synchronized void addShutdownHook(Thread hook) {
        if (shutdownHooks_.contains(hook)) {
            return;
        }
        shutdownHooks_.add(hook);
        try {
            Runtime.getRuntime().addShutdownHook(hook);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static synchronized void removeShutdownHooks() {
        Iterator it = shutdownHooks_.iterator();
        boolean vmShutdown = false;
        while (it.hasNext()) {
            Thread t = (Thread)it.next();
            if (!t.equals(Thread.currentThread())) continue;
            vmShutdown = true;
        }
        it = shutdownHooks_.iterator();
        while (!vmShutdown && it.hasNext()) {
            Thread hook = (Thread)it.next();
            it.remove();
            try {
                Runtime.getRuntime().removeShutdownHook(hook);
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    public static TransactionService getTransactionService() {
        return service_;
    }

    public static synchronized void registerTransactionServicePlugin(TransactionServicePlugin l) {
        if (service_ != null) {
            service_.addTSListener(l);
        }
        tsListenersList_.add(l);
    }

    public static synchronized void unregisterTransactionServicePlugin(TransactionServicePlugin l) {
        if (service_ != null) {
            service_.removeTSListener(l);
        }
        tsListenersList_.remove(l);
    }

    public static synchronized void installCompositeTransactionManager(CompositeTransactionManager compositeTransactionManager) {
        ctxmgr_ = compositeTransactionManager;
    }

    public static CompositeTransactionManager getCompositeTransactionManager() {
        return ctxmgr_;
    }

    public static synchronized void addResource(RecoverableResource resource) throws IllegalStateException {
        Configuration.purgeResources();
        if (resources_.containsKey(resource.getName())) {
            throw new IllegalStateException("Another resource already exists with name " + resource.getName() + " - pick a different name");
        }
        resource.setRecoveryService(recoveryService_);
        resources_.put(resource.getName(), resource);
        resourceList_.add(resource);
    }

    public static RecoverableResource removeResource(String name) {
        RecoverableResource ret = null;
        if (name != null && (ret = (RecoverableResource)resources_.remove(name)) != null) {
            resourceList_.remove(ret);
        }
        return ret;
    }

    public static RecoverableResource getResource(String name) {
        RecoverableResource res = null;
        if (name != null) {
            res = (RecoverableResource)resources_.get(name);
        }
        return res;
    }

    public static Collection<RecoverableResource> getResources() {
        Vector ret = (Vector)resourceList_.clone();
        return ret;
    }

    protected static synchronized Assembler getAssembler() {
        if (assembler == null) {
            Configuration.loadAssembler();
        }
        return assembler;
    }

    private static void loadAssembler() {
        ServiceLoader<Assembler> loader = ServiceLoader.load(Assembler.class, Configuration.class.getClassLoader());
        Iterator<Assembler> it = loader.iterator();
        if (!it.hasNext()) {
            throw new SysException("No Assembler service found - please make sure that the right jars are in your classpath");
        }
        assembler = it.next();
    }

    public static synchronized ConfigProperties getConfigProperties() {
        if (configProperties == null) {
            configProperties = Configuration.getAssembler().initializeProperties();
        }
        return configProperties;
    }

    static synchronized void resetConfigProperties() {
        configProperties = null;
    }

    public static synchronized void shutdown(boolean force) {
        long maxWaitTime = 0L;
        if (!force) {
            maxWaitTime = Configuration.getConfigProperties().getDefaultMaxWaitTimeOnShutdown();
        }
        Configuration.shutdown(maxWaitTime);
    }

    public static synchronized void shutdown(long maxWaitTime) {
        if (service_ != null) {
            service_.shutdown(maxWaitTime);
            Configuration.notifyAfterShutdown();
            Configuration.removeShutdownHooks();
            Configuration.removeAndCloseResources(maxWaitTime <= 0L);
            Configuration.clearSystemComponents();
        }
    }

    private static void clearSystemComponents() {
        service_ = null;
        recoveryService_ = null;
        ctxmgr_ = null;
        tsListenersList_.clear();
        Configuration.resetConfigProperties();
        assembler = null;
    }

    private static void notifyAfterShutdown() {
        for (TransactionServicePlugin p : tsListenersList_) {
            p.afterShutdown();
        }
    }

    private static void removeAndCloseResources(boolean force) {
        Collection<RecoverableResource> resources = Configuration.getResources();
        for (RecoverableResource res : resources) {
            Configuration.removeResource(res.getName());
            try {
                res.close();
            }
            catch (ResourceException re) {
                if (force) continue;
                re.printStackTrace();
            }
        }
    }

    public static synchronized boolean init() {
        boolean startupInitiated = false;
        if (service_ == null) {
            startupInitiated = true;
            Configuration.addAllTransactionServicePluginServicesFromClasspath();
            ConfigProperties configProperties = Configuration.getConfigProperties();
            Configuration.notifyBeforeInit(configProperties);
            Configuration.assembleSystemComponents(configProperties);
            Configuration.initializeSystemComponents(configProperties);
            Configuration.notifyAfterInit();
            if (configProperties.getForceShutdownOnVmExit()) {
                Configuration.addShutdownHook(new ForceShutdownHook());
            }
        }
        return startupInitiated;
    }

    private static void notifyAfterInit() {
        for (TransactionServicePlugin p : tsListenersList_) {
            p.afterInit();
        }
        for (RecoverableResource r : resourceList_) {
            r.setRecoveryService(recoveryService_);
        }
    }

    private static void initializeSystemComponents(ConfigProperties configProperties) {
        service_.init(configProperties.getCompletedProperties());
    }

    private static void notifyBeforeInit(ConfigProperties configProperties) {
        for (TransactionServicePlugin p : tsListenersList_) {
            p.beforeInit();
        }
    }

    private static void assembleSystemComponents(ConfigProperties configProperties) {
        Assembler assembler = Configuration.getAssembler();
        service_ = assembler.assembleTransactionService(configProperties);
        recoveryService_ = service_.getRecoveryService();
        ctxmgr_ = assembler.assembleCompositeTransactionManager();
    }

    public static RecoveryLog getRecoveryLog() {
        return recoveryService_.getRecoveryLog();
    }

    public static RecoveryService getRecoveryService() {
        return recoveryService_;
    }

    static {
        tsListenersList_ = new Vector();
        shutdownHooks_ = new ArrayList();
    }

    private static class ForceShutdownHook
    extends Thread {
        private ForceShutdownHook() {
        }

        @Override
        public void run() {
            Configuration.shutdown(true);
        }
    }
}

