/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.util;

public class UniqueIdMgr {
    private static final int MAX_LENGTH_OF_NUMERIC_SUFFIX = 13;
    private static final int MAX_COUNTER_WITHIN_SAME_MILLIS = 32000;
    private final String commonPartOfId;
    private int lastcounter;

    public UniqueIdMgr(String server) {
        this.commonPartOfId = UniqueIdMgr.getCommonPartOfId(server);
        this.lastcounter = 0;
    }

    private String getCountWithLeadingZeroes(int number) {
        String ret = Long.toString(number);
        int max = Long.toString(32000L).length();
        StringBuffer zeroes = new StringBuffer();
        for (int len = ret.length(); len < max; ++len) {
            zeroes.append("0");
        }
        ret = zeroes.append(ret).toString();
        return ret;
    }

    public String get() {
        this.incrementAndGet();
        StringBuffer buffer = new StringBuffer();
        return buffer.append(this.commonPartOfId).append(System.currentTimeMillis()).append(this.getCountWithLeadingZeroes(this.lastcounter)).toString();
    }

    private synchronized void incrementAndGet() {
        ++this.lastcounter;
        if (this.lastcounter == 32000) {
            this.lastcounter = 0;
        }
    }

    private static String getCommonPartOfId(String server) {
        StringBuffer ret = new StringBuffer(64);
        ret.append(server);
        return ret.toString();
    }

    public int getMaxIdLengthInBytes() {
        return this.commonPartOfId.getBytes().length + 13;
    }
}

