/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.util;

import com.atomikos.util.VersionedFile;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;

public class UniqueIdMgr {
    private static long MAX_PER_EPOCH = 32000L;
    private static final int MAX_LENGTH_OF_NUMERIC_SUFFIX = 16;
    String server_;
    long epoch_;
    long lastcounter_;
    int limit_;
    private String prefix_;
    private String suffix_;
    private VersionedFile file_;

    public UniqueIdMgr(String server) {
        this(server, "./");
        this.limit_ = -1;
        this.server_ = server;
        this.epoch_ = new Date().getDate();
        this.lastcounter_ = 0L;
    }

    public UniqueIdMgr(String server, String directorypath) {
        this(server, directorypath, -1);
    }

    public UniqueIdMgr(String server, String directorypath, int limit) {
        this.limit_ = limit;
        this.server_ = server;
        this.file_ = new VersionedFile(directorypath, server, ".epoch");
        this.setSuffix("");
        this.setPrefix("");
        try {
            this.epoch_ = this.readEpoch();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        this.lastcounter_ = 0L;
    }

    public void setSuffix(String suffix) {
        this.suffix_ = suffix;
    }

    public void setPrefix(String prefix) {
        this.prefix_ = prefix;
    }

    protected long readEpoch() throws IOException {
        long ret = 0L;
        try {
            FileInputStream fin = this.file_.openLastValidVersionForReading();
            DataInputStream din = new DataInputStream(fin);
            ret = din.readLong();
            din.close();
            fin.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.writeEpoch(ret + 1L);
        if (ret + 1L <= 0L) {
            throw new RuntimeException("Epoch overflow!");
        }
        return ret + 1L;
    }

    protected void writeEpoch(long value) throws IOException {
        if (value <= 0L || this.limit_ >= 0 && value > (long)this.limit_) {
            throw new RuntimeException("Epoch overflow!");
        }
        FileOutputStream fout = this.file_.openNewVersionForWriting();
        DataOutputStream dout = new DataOutputStream(fout);
        dout.writeLong(value);
        dout.flush();
        fout.flush();
        fout.getFD().sync();
        dout.close();
        fout.close();
        this.file_.discardBackupVersion();
        this.file_.close();
    }

    private String getCountWithLeadingZeroes(long number) {
        String ret = Long.toString(number);
        int max = Long.toString(MAX_PER_EPOCH).length();
        StringBuffer zeroes = new StringBuffer();
        for (int len = ret.length(); len < max; ++len) {
            zeroes.append("0");
        }
        ret = zeroes.append(ret).toString();
        return ret;
    }

    public synchronized String get() {
        ++this.lastcounter_;
        if (this.lastcounter_ > MAX_PER_EPOCH) {
            this.lastcounter_ = 0L;
            ++this.epoch_;
            try {
                this.writeEpoch(this.epoch_);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.getCommonPartOfId() + this.getCountWithLeadingZeroes(this.lastcounter_) + this.getCountWithLeadingZeroes(this.epoch_);
    }

    private String getCommonPartOfId() {
        StringBuffer ret = new StringBuffer(64);
        ret.append(this.prefix_).append(this.server_).append(this.suffix_);
        return ret.toString();
    }

    public int getMaxIdLengthInBytes() {
        return this.getCommonPartOfId().getBytes().length + 16;
    }
}

