/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.diagnostics;

import com.atomikos.diagnostics.Console;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class RotatingFileConsole
implements Console {
    private static final Object eolIndicatorParameter = new Object();
    private int level = 1;
    private Logger logger;
    private FileHandler handler;

    public RotatingFileConsole(String string, int n, int n2) throws SecurityException, IOException {
        this.setLevel(1);
        this.handler = n >= 0 ? new FileHandler(string, n, n2) : new FileHandler(string);
        this.logger = Logger.getLogger("com.atomikos.diagnostics");
        this.logger.addHandler(this.handler);
        this.logger.setLevel(Level.ALL);
        this.logger.setUseParentHandlers(false);
        this.handler.setFormatter(new FileFormatter());
    }

    public void println(String string) throws IOException {
        this.logger.log(Level.WARNING, string, eolIndicatorParameter);
    }

    public void print(String string) throws IOException {
        Object var2_2 = null;
        this.logger.log(Level.WARNING, string, (Object)var2_2);
    }

    public void println(String string, int n) throws IOException {
        if (this.getLevel() >= n) {
            this.println(string);
        }
    }

    public void print(String string, int n) throws IOException {
        if (this.getLevel() >= n) {
            this.print(string);
        }
    }

    public void close() throws IOException {
        this.handler.close();
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public int getLevel() {
        return this.level;
    }

    private static class FileFormatter
    extends Formatter {
        private DateFormat formatter = new SimpleDateFormat("yy-MM-dd kk:mm:ss,SSS");

        FileFormatter() {
        }

        public String format(LogRecord logRecord) {
            StringBuffer stringBuffer = new StringBuffer();
            Object[] objectArray = logRecord.getParameters();
            if (objectArray[0] != null) {
                stringBuffer.append(this.formatter.format(new Date()));
                stringBuffer.append(" [" + Thread.currentThread().getName() + "] ");
            }
            stringBuffer.append(logRecord.getMessage());
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }
    }
}

