/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.beans;

import com.atomikos.beans.MemberFilter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class MainMethodFilter
implements MemberFilter {
    public boolean acceptsField(Field field) {
        return false;
    }

    public boolean acceptsMethod(Method method) {
        if (!method.getName().endsWith("main")) {
            return false;
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != 1) {
            return false;
        }
        if (!classArray[0].getName().startsWith("[Ljava.lang.String")) {
            return false;
        }
        int n = method.getModifiers();
        if (!Modifier.isPublic(n)) {
            return false;
        }
        if (!Modifier.isStatic(n)) {
            return false;
        }
        return method.getReturnType().getName().equals("void");
    }

    public boolean acceptsConstructor(Constructor constructor) {
        return false;
    }
}

