/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.internal.rest.history;

import com.atlassian.webhooks.history.InvocationResult;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class RestInvocationResult
extends LinkedHashMap<String, Object> {
    public static final RestInvocationResult EXAMPLE = new RestInvocationResult("200", "SUCCESS");
    public static final RestInvocationResult EXAMPLE_FAILURE = new RestInvocationResult("404", "FAILURE");
    public static final RestInvocationResult EXAMPLE_ERROR = new RestInvocationResult("Detailed error message", "ERROR");
    private static final String DESCRIPTION = "description";
    private static final String OUTCOME = "outcome";

    public RestInvocationResult() {
    }

    public RestInvocationResult(@Nonnull InvocationResult result) {
        this.put(DESCRIPTION, result.getDescription());
        this.put(OUTCOME, result.getOutcome());
    }

    public RestInvocationResult(String description, String outcome) {
        this.put(DESCRIPTION, description);
        this.put(OUTCOME, outcome);
    }

    public static RestInvocationResult valueOf(Object value) {
        if (value instanceof RestInvocationResult) {
            return (RestInvocationResult)value;
        }
        if (value instanceof InvocationResult) {
            return new RestInvocationResult((InvocationResult)value);
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return new RestInvocationResult((String)map.get(DESCRIPTION), (String)map.get(OUTCOME));
        }
        return null;
    }
}

