/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.internal.rest;

import com.atlassian.webhooks.Webhook;
import com.atlassian.webhooks.WebhookEvent;
import com.atlassian.webhooks.internal.rest.RestWebhookCredentials;
import com.atlassian.webhooks.internal.rest.history.RestInvocationHistory;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

@JsonSerialize
public class RestWebhook
extends LinkedHashMap<String, Object> {
    private static final String ACTIVE = "active";
    private static final String CONFIGURATION = "configuration";
    private static final String CREDENTIALS = "credentials";
    private static final String CREATED_DATE = "createdDate";
    private static final String EVENTS = "events";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String SCOPE_TYPE = "scopeType";
    private static final String SSL_VERIFICATION_REQUIRED = "sslVerificationRequired";
    private static final String STATISTICS = "statistics";
    private static final String UPDATED_DATE = "updatedDate";
    private static final String USERNAME = "username";
    private static final String URL = "url";
    private static final Date exampleDate = Date.from(Instant.ofEpochSecond(1513106011L));
    public static RestWebhook EXAMPLE = new RestWebhook(10, "Webhook Name", exampleDate, exampleDate, (Set<String>)ImmutableSet.of((Object)"repo:refs_changed", (Object)"repo:modified"), (Map<String, String>)ImmutableMap.of((Object)"secret", (Object)"password"), (Map<String, String>)ImmutableMap.of((Object)"username", (Object)"admin"), "http://example.com", true, "repository", true);

    public RestWebhook() {
    }

    public RestWebhook(Webhook webhook) {
        if (webhook.getId() > 0) {
            this.put(ID, webhook.getId());
        }
        this.put(NAME, webhook.getName());
        this.put(CREATED_DATE, webhook.getCreatedDate());
        this.put(UPDATED_DATE, webhook.getUpdatedDate());
        this.put(EVENTS, webhook.getEvents().stream().map(WebhookEvent::getId).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet)));
        this.put(CONFIGURATION, webhook.getConfiguration());
        webhook.getCredentials().ifPresent(credentials -> this.put(CREDENTIALS, ImmutableMap.of((Object)USERNAME, (Object)credentials.getUsername())));
        this.put(URL, webhook.getUrl());
        this.put(ACTIVE, webhook.isActive());
        this.put(SCOPE_TYPE, webhook.getScope().getType());
        this.put(SSL_VERIFICATION_REQUIRED, webhook.isSslVerificationRequired());
    }

    private RestWebhook(int id, String name, Date createdDate, Date updatedDate, Set<String> events, Map<String, String> configuration, Map<String, String> credentials, String url, boolean isActive, String scopeType, boolean sslVerificationRequired) {
        this.put(ID, id);
        this.put(NAME, name);
        this.put(CREATED_DATE, createdDate);
        this.put(UPDATED_DATE, updatedDate);
        this.put(EVENTS, events);
        this.put(CONFIGURATION, configuration);
        this.put(CREDENTIALS, credentials);
        this.put(URL, url);
        this.put(ACTIVE, isActive);
        this.put(SCOPE_TYPE, scopeType);
        this.put(SSL_VERIFICATION_REQUIRED, sslVerificationRequired);
    }

    @Nullable
    public Boolean getActive() {
        Object value = this.get(ACTIVE);
        return value instanceof Boolean ? (Boolean)value : null;
    }

    @Nonnull
    public Map<String, String> getConfiguration() {
        Object config = this.get(CONFIGURATION);
        if (config instanceof Map) {
            return (Map)config;
        }
        return Collections.emptyMap();
    }

    @Nonnull
    public Set<String> getEvents() {
        Object events = this.get(EVENTS);
        if (events instanceof Collection) {
            return new HashSet<String>((Collection)events);
        }
        return Collections.emptySet();
    }

    @Nonnull
    public Optional<RestWebhookCredentials> getCredentials() {
        return Optional.ofNullable(RestWebhookCredentials.valueOf(this.get(CREDENTIALS)));
    }

    public String getName() {
        return StringUtils.trimToNull((String)this.getStringProperty(NAME));
    }

    public String getScopeType() {
        return StringUtils.trimToNull((String)this.getStringProperty(SCOPE_TYPE));
    }

    public Boolean getSslVerificationRequired() {
        Object value = this.get(SSL_VERIFICATION_REQUIRED);
        return value instanceof Boolean ? (Boolean)value : true;
    }

    public String getUrl() {
        return StringUtils.trimToNull((String)this.getStringProperty(URL));
    }

    public void setStatistics(RestInvocationHistory statistics) {
        if (statistics != null) {
            this.put(STATISTICS, statistics);
        }
    }

    private String getStringProperty(String key) {
        return Objects.toString(this.get(key), null);
    }
}

