/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.internal.rest;

import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.webhooks.NoSuchWebhookException;
import com.atlassian.webhooks.PingRequest;
import com.atlassian.webhooks.Webhook;
import com.atlassian.webhooks.WebhookCreateRequest;
import com.atlassian.webhooks.WebhookCredentials;
import com.atlassian.webhooks.WebhookEvent;
import com.atlassian.webhooks.WebhookScope;
import com.atlassian.webhooks.WebhookSearchRequest;
import com.atlassian.webhooks.WebhookService;
import com.atlassian.webhooks.WebhookUpdateRequest;
import com.atlassian.webhooks.diagnostics.WebhookDiagnosticsResult;
import com.atlassian.webhooks.history.HistoricalInvocationRequest;
import com.atlassian.webhooks.history.InvocationHistory;
import com.atlassian.webhooks.history.InvocationHistoryByEventRequest;
import com.atlassian.webhooks.history.InvocationHistoryRequest;
import com.atlassian.webhooks.history.InvocationHistoryService;
import com.atlassian.webhooks.history.InvocationOutcome;
import com.atlassian.webhooks.internal.rest.RestResponseBuilder;
import com.atlassian.webhooks.internal.rest.RestWebhook;
import com.atlassian.webhooks.internal.rest.RestWebhookCredentials;
import com.atlassian.webhooks.internal.rest.RestWebhookRequestResponse;
import com.atlassian.webhooks.internal.rest.history.RestDetailedInvocation;
import com.atlassian.webhooks.internal.rest.history.RestInvocationHistory;
import com.atlassian.webhooks.util.WebhookScopeUtil;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhooksResourceHelper {
    private static final Pattern URL_VARIABLE_REGEX = Pattern.compile("\\{(.*?)}/?");
    protected final Logger log;
    private final I18nResolver i18nResolver;
    private final RestResponseBuilder restBuilder;
    private final Supplier<Object> invocationHistoryServiceProvider;
    private final Supplier<Object> webhooksServiceProvider;
    private final Consumer<WebhookScope> webhooksScopeAdminValidator;

    public WebhooksResourceHelper(I18nResolver i18nResolver, RestResponseBuilder restBuilder, Supplier<Object> invocationHistoryServiceProvider, Supplier<Object> webhookServiceProvider, Consumer<WebhookScope> webhookScopeAdminValidator) {
        this.i18nResolver = i18nResolver;
        this.restBuilder = restBuilder;
        this.invocationHistoryServiceProvider = invocationHistoryServiceProvider;
        this.webhooksScopeAdminValidator = webhookScopeAdminValidator;
        this.webhooksServiceProvider = webhookServiceProvider;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    private InvocationHistoryService getInvocationHistoryService() {
        return (InvocationHistoryService)this.invocationHistoryServiceProvider.get();
    }

    private WebhookService getWebhookService() {
        return (WebhookService)this.webhooksServiceProvider.get();
    }

    private void validateCanAdmin(WebhookScope scope) {
        this.webhooksScopeAdminValidator.accept(scope);
    }

    public Response createWebhook(UriInfo uriInfo, WebhookScope scope, RestWebhook webhook) {
        WebhookService service = this.getWebhookService();
        this.validateCanAdmin(scope);
        WebhookCreateRequest.Builder builder = (WebhookCreateRequest.Builder)((WebhookCreateRequest.Builder)((WebhookCreateRequest.Builder)((WebhookCreateRequest.Builder)((WebhookCreateRequest.Builder)WebhookCreateRequest.builder().configuration(webhook.getConfiguration())).event(this.toEvents(service, webhook.getEvents()))).name(webhook.getName())).scope(scope)).url(webhook.getUrl());
        Boolean active = webhook.getActive();
        Boolean sslVerificationRequired = webhook.getSslVerificationRequired();
        if (active != null) {
            builder.active(active.booleanValue());
        }
        if (sslVerificationRequired != null) {
            builder.sslVerificationRequired(sslVerificationRequired.booleanValue());
        }
        webhook.getCredentials().ifPresent(credentials -> builder.credentials(this.toCredentials((RestWebhookCredentials)credentials)));
        Webhook result = service.create(builder.build());
        return Response.created((URI)uriInfo.getRequestUriBuilder().path(Integer.toString(result.getId())).build(new Object[0])).entity((Object)new RestWebhook(result)).build();
    }

    public Response deleteWebhook(WebhookScope scope, int webhookId) {
        WebhookService service = this.getWebhookService();
        this.validateCanAdmin(scope);
        if (!this.scopeMatchesWebhook(service, webhookId, scope) || !service.delete(webhookId)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity(this.noSuchWebhook(webhookId)).build();
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    public Response findWebhooks(UriInfo uriInfo, WebhookScope scope, List<WebhookScope> scopes, List<String> eventIds, boolean statistics, int start, int limit) {
        Map hookStats;
        boolean hasNextPage;
        WebhookService service = this.getWebhookService();
        this.validateCanAdmin(scope);
        List<String> decodedEventIds = eventIds.stream().map(WebhooksResourceHelper::decodeURL).collect(Collectors.toList());
        Set<WebhookEvent> events = this.toEvents(service, decodedEventIds);
        List hooks = service.search(((WebhookSearchRequest.Builder)((WebhookSearchRequest.Builder)WebhookSearchRequest.builder().event(events)).scope(scopes)).offset(start).limit(limit + 1).build());
        boolean bl = hasNextPage = hooks.size() > limit;
        if (hasNextPage) {
            hooks = hooks.subList(0, limit);
        }
        if (statistics && !hooks.isEmpty()) {
            InvocationHistoryService historyService = this.getInvocationHistoryService();
            Set ids = (Set)hooks.stream().map(Webhook::getId).collect(ImmutableSet.toImmutableSet());
            hookStats = this.isPrimaryScope(scope, scopes) ? historyService.getByWebhook((Collection)ids) : historyService.getByWebhookAndScope((Collection)ids, scope);
        } else {
            hookStats = Collections.emptyMap();
        }
        List restHooks = hooks.stream().map(hook -> {
            RestWebhook restHook = new RestWebhook((Webhook)hook);
            InvocationHistory stats = (InvocationHistory)hookStats.get(hook.getId());
            if (stats != null) {
                restHook.setStatistics(new RestInvocationHistory(stats));
            }
            return restHook;
        }).collect(Collectors.toList());
        return Response.ok((Object)this.restBuilder.page(uriInfo, start, limit, restHooks, hasNextPage)).build();
    }

    public Response findWebhooks(UriInfo uriInfo, WebhookScope scope, List<String> eventIds, boolean statistics, int start, int limit) {
        return this.findWebhooks(uriInfo, scope, Collections.singletonList(scope), eventIds, statistics, start, limit);
    }

    public Response getLatestInvocation(WebhookScope scope, int webhookId, String eventId, Set<String> outcomeNames) {
        InvocationHistoryService historyService = this.getInvocationHistoryService();
        this.validateCanAdmin(scope);
        HashSet<InvocationOutcome> outcomes = new HashSet<InvocationOutcome>();
        for (String outcomeName : outcomeNames) {
            try {
                outcomes.add(InvocationOutcome.valueOf((String)outcomeName.toUpperCase(Locale.ROOT)));
            }
            catch (IllegalArgumentException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(this.unknownOutcome(outcomeName)).build();
            }
        }
        HistoricalInvocationRequest latestInvocationRequest = HistoricalInvocationRequest.builder((int)webhookId).eventId(StringUtils.trimToNull((String)eventId)).outcome(outcomes).build();
        try {
            Optional latestInvocation = historyService.getLatestInvocation(latestInvocationRequest);
            return latestInvocation.map(RestDetailedInvocation::new).map(Response::ok).orElseGet(Response::noContent).build();
        }
        catch (NoSuchWebhookException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity(this.noSuchWebhook(webhookId)).build();
        }
    }

    public Response getStatistics(WebhookScope scope, int webhookId, String eventId) {
        InvocationHistoryService historyService = this.getInvocationHistoryService();
        WebhookService service = this.getWebhookService();
        this.validateCanAdmin(scope);
        if (!this.scopeMatchesWebhook(service, webhookId, scope)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity(this.noSuchWebhook(webhookId)).build();
        }
        InvocationHistoryRequest historyRequest = InvocationHistoryRequest.builder().eventId(StringUtils.trimToNull((String)eventId)).webhookId(webhookId).build();
        try {
            InvocationHistory history = historyService.get(historyRequest);
            return Response.ok((Object)new RestInvocationHistory(history)).build();
        }
        catch (NoSuchWebhookException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity(this.noSuchWebhook(webhookId)).build();
        }
    }

    public Response getStatisticsSummary(WebhookScope scope, int webhookId) {
        InvocationHistoryService historyService = this.getInvocationHistoryService();
        WebhookService service = this.getWebhookService();
        this.validateCanAdmin(scope);
        if (!this.scopeMatchesWebhook(service, webhookId, scope)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity(this.noSuchWebhook(webhookId)).build();
        }
        InvocationHistoryByEventRequest request = InvocationHistoryByEventRequest.builder((int)webhookId).build();
        try {
            Map<String, RestInvocationHistory> invocationHistories = historyService.getByEvent(request).entrySet().stream().collect(Collectors.toMap(entry -> ((WebhookEvent)entry.getKey()).getId(), entry -> new RestInvocationHistory((InvocationHistory)entry.getValue())));
            return Response.ok(invocationHistories).build();
        }
        catch (NoSuchWebhookException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity(this.noSuchWebhook(webhookId)).build();
        }
    }

    public Response getWebhook(WebhookScope scope, int webhookId, boolean includeStatistics) {
        WebhookService service = this.getWebhookService();
        this.validateCanAdmin(scope);
        if (!this.scopeMatchesWebhook(service, webhookId, scope)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity(this.noSuchWebhook(webhookId)).build();
        }
        Webhook webhook = service.findById(webhookId).orElse(null);
        if (webhook == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity(this.noSuchWebhook(webhookId)).build();
        }
        RestWebhook restWebhook = new RestWebhook(webhook);
        if (includeStatistics) {
            InvocationHistoryService historyService = this.getInvocationHistoryService();
            InvocationHistoryRequest historyRequest = InvocationHistoryRequest.builder().webhookId(webhookId).build();
            InvocationHistory history = historyService.get(historyRequest);
            restWebhook.setStatistics(new RestInvocationHistory(history));
        }
        return Response.ok((Object)restWebhook).build();
    }

    public Response testWebhook(WebhookScope scope, String url) {
        return this.testWebhook(scope, url, true, null, null, null);
    }

    public Response testWebhook(WebhookScope scope, String url, boolean sslVerificationRequired, Integer webhookId, String username, String password) {
        WebhookService service = this.getWebhookService();
        this.validateCanAdmin(scope);
        String parsedURL = this.removeURLParameters(url);
        PingRequest.Builder request = PingRequest.builder((String)parsedURL).scope(scope).sslVerificationRequired(sslVerificationRequired);
        if (username != null || password != null) {
            request.credentials((WebhookCredentials)new SimpleWebhookCredentials(username, password));
        } else if (webhookId != null) {
            Webhook webhook = service.findById(webhookId.intValue()).orElse(null);
            if (webhook == null) {
                this.log.warn("No webhook was found for ID {}. Connection will be tested without credentials.", (Object)webhookId);
            } else {
                webhook.getCredentials().ifPresent(credentials -> request.credentials((WebhookCredentials)new SimpleWebhookCredentials(credentials.getUsername().orElse(null), credentials.getPassword().orElse(null))));
            }
        }
        Future future = service.ping(request.build());
        try {
            WebhookDiagnosticsResult result = (WebhookDiagnosticsResult)future.get();
            if (result.isError()) {
                String errorMessage = this.getErrorMessage(parsedURL, result.getError());
                return Response.ok((Object)new RestWebhookRequestResponse(result.getRequest(), errorMessage)).build();
            }
            return Response.ok((Object)new RestWebhookRequestResponse(result.getRequest(), result.getResponse())).build();
        }
        catch (InterruptedException | ExecutionException e) {
            String errorMessage = this.getErrorMessage(parsedURL, e.getCause());
            return Response.ok((Object)new RestWebhookRequestResponse(null, errorMessage)).build();
        }
    }

    public Response update(WebhookScope scope, int webhookId, RestWebhook webhook) {
        WebhookService service = this.getWebhookService();
        this.validateCanAdmin(scope);
        if (!this.scopeMatchesWebhook(service, webhookId, scope)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity(this.noSuchWebhook(webhookId)).build();
        }
        WebhookUpdateRequest.Builder builder = (WebhookUpdateRequest.Builder)((WebhookUpdateRequest.Builder)((WebhookUpdateRequest.Builder)((WebhookUpdateRequest.Builder)((WebhookUpdateRequest.Builder)WebhookUpdateRequest.builder().configuration(webhook.getConfiguration())).event(this.toEvents(service, webhook.getEvents()))).name(webhook.getName())).scope(scope)).url(webhook.getUrl());
        Boolean active = webhook.getActive();
        Boolean sslVerificationRequired = webhook.getSslVerificationRequired();
        if (active != null) {
            builder.active(active.booleanValue());
        }
        if (sslVerificationRequired != null) {
            builder.sslVerificationRequired(sslVerificationRequired.booleanValue());
        }
        webhook.getCredentials().ifPresent(credentials -> builder.credentials(this.toCredentials((RestWebhookCredentials)credentials)));
        try {
            Webhook result = service.update(webhookId, builder.build());
            return Response.ok().entity((Object)new RestWebhook(result)).build();
        }
        catch (NoSuchWebhookException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity(this.noSuchWebhook(webhookId)).build();
        }
    }

    private static String decodeURL(String fragment) {
        try {
            return URLDecoder.decode(fragment, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    private String getErrorMessage(String url, Throwable error) {
        if (error.getCause() instanceof UnknownHostException) {
            return this.i18nResolver.getText("webhooks.rest.unknown.host", new Serializable[]{url});
        }
        if (error.getCause() instanceof SocketException) {
            return this.i18nResolver.getText("webhooks.rest.connect.error");
        }
        if (error.getCause() instanceof SSLException) {
            return this.i18nResolver.getText("webhooks.rest.ssl.error");
        }
        this.log.warn("Request to {} resulted in an error: {}", (Object)url, (Object)error.getLocalizedMessage());
        return this.i18nResolver.getText("webhooks.rest.other.error");
    }

    private boolean isPrimaryScope(WebhookScope scope, List<WebhookScope> scopes) {
        return scopes.size() == 1 && ((WebhookScope)Iterables.getOnlyElement(scopes)).equals(scope);
    }

    private Object noSuchWebhook(int webhookId) {
        return this.restBuilder.error("webhookId", this.i18nResolver.getText("webhooks.rest.nosuchwebhook", new Serializable[]{Integer.valueOf(webhookId)}));
    }

    private String removeURLParameters(String url) {
        return URL_VARIABLE_REGEX.matcher(url).replaceAll("");
    }

    private boolean scopeMatchesWebhook(WebhookService service, int webhookId, WebhookScope scope) {
        Optional possibleWebhook = service.findById(webhookId);
        return possibleWebhook.map(webhook -> WebhookScopeUtil.equals((WebhookScope)scope, (WebhookScope)webhook.getScope())).orElse(false);
    }

    private WebhookCredentials toCredentials(RestWebhookCredentials credentials) {
        return new SimpleWebhookCredentials(credentials.getUsername(), credentials.getPassword());
    }

    private Set<WebhookEvent> toEvents(WebhookService service, Collection<String> eventIds) {
        return (Set)eventIds.stream().map(eventId -> service.getEvent(eventId).orElseGet(() -> new UnknownWebhookEvent((String)eventId))).collect(ImmutableSet.toImmutableSet());
    }

    private Object unknownOutcome(String outcomeName) {
        return this.restBuilder.error("outcome", this.i18nResolver.getText("webhooks.rest.nosuchoutcome", new Serializable[]{outcomeName}));
    }

    private static class SimpleWebhookCredentials
    implements WebhookCredentials {
        private final String password;
        private final String username;

        private SimpleWebhookCredentials(String username, String password) {
            this.password = password;
            this.username = username;
        }

        @Nonnull
        public Optional<String> getPassword() {
            return Optional.ofNullable(this.password);
        }

        @Nonnull
        public Optional<String> getUsername() {
            return Optional.ofNullable(this.username);
        }
    }

    private static class UnknownWebhookEvent
    implements WebhookEvent {
        private final String id;

        private UnknownWebhookEvent(String id) {
            this.id = id;
        }

        @Nonnull
        public String getI18nKey() {
            return this.id;
        }

        @Nonnull
        public String getId() {
            return this.id;
        }
    }
}

