/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.internal.rest;

import com.atlassian.webhooks.request.WebhookHttpRequest;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableMap;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonSerialize
public class RestWebhookRequest
extends LinkedHashMap<String, Object> {
    public static RestWebhookRequest EXAMPLE = new RestWebhookRequest("http://example.com/callback", null, "POST", (Map<String, String>)ImmutableMap.of((Object)"Accept", (Object)"*/*"));
    private final String BODY = "body";
    private final String HEADERS = "headers";
    private final String METHOD = "method";
    private final String URL = "url";

    public RestWebhookRequest() {
    }

    public RestWebhookRequest(WebhookHttpRequest request) {
        this.put("url", request.getUrl());
        this.put("body", request.getContent() != null ? new String(request.getContent(), StandardCharsets.UTF_8) : null);
        this.put("method", request.getMethod());
        this.put("headers", request.getHeaders());
    }

    private RestWebhookRequest(String url, String body, String method, Map<String, String> headers) {
        this.put("url", url);
        this.put("body", body);
        this.put("method", method);
        this.put("headers", headers);
    }
}

