package com.atlassian.web.servlet.api;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.net.URI;

/**
 * Forwards requests to a location. Any state should be thread-confined.
 *
 * @since 1.0
 */
public interface ServletForwarder {

    /**
     * Forwards the request to the specified location inside the servlet container.
     *
     * @param request  the request to forward
     * @param response the response for the forwarded location to contribute to
     * @param location request-context-relative location to forward to
     * @since 1.0
     */
    void forward(HttpServletRequest request, HttpServletResponse response, URI location);

    /**
     * Forwards the request to the specified location inside the servlet container if safe to do so.
     * Implementations should check the forwarding safety by consulting all available {@link ForwardAuthorizer}s.
     *
     * @param request  the request to forward
     * @param response the response for the forwarded location to contribute to
     * @param location request-context-relative location to forward to
     * @return true if request was forwarded
     * @since 2.1.0
     */
    boolean forwardSafely(HttpServletRequest request, HttpServletResponse response, URI location);
}
