package com.atlassian.velocity.htmlsafe.introspection;

import org.apache.velocity.util.introspection.SecureUberspector;

/**
 * A Secure Velocity uberspect that allow use of single classes or single packages
 * that are under restricted packages specified by {@code introspector.restrict.packages}.
 * <p>
 * The class is most useful for scenarios where classes under package are potentially harmful
 * but package also contains safe classes.
 * <p>
 * https://jira.atlassian.com/browse/JRASERVER-71733
 *
 * @since 3.2.0
 */
public class AllowlistSecureUberspector extends SecureUberspector {
    @Override
    public void init() throws Exception {
        super.init();
        introspector = new AllowlistSecureIntrospector(log, runtimeServices);
    }
}
