package com.atlassian.velocity.htmlsafe;

import com.atlassian.velocity.htmlsafe.util.Check;
import org.apache.velocity.app.event.ReferenceInsertionEventHandler;
import org.apache.velocity.context.Context;
import org.apache.velocity.util.ContextAware;

/**
 * A {@link ReferenceInsertionEventHandler} that delegates reference insertion processing to the provided
 * {@link ReferenceInsertionPolicy}.
 */
public final class PolicyBasedReferenceInsertionHandler implements ReferenceInsertionEventHandler, ContextAware {
    private Context context;

    private final ReferenceInsertionPolicy insertionPolicy;

    public PolicyBasedReferenceInsertionHandler(ReferenceInsertionPolicy insertionPolicy) {
        Check.notNull(insertionPolicy, "insertionPolicy must not be null");
        this.insertionPolicy = insertionPolicy;
    }

    public Object referenceInsert(String reference, Object value) {
        return insertionPolicy.getReferenceInsertionEventHandler(context).referenceInsert(reference, value);
    }

    public void setContext(Context context) {
        this.context = context;
    }
}
