package com.atlassian.velocity.htmlsafe.introspection;

import org.apache.velocity.util.introspection.VelMethod;

import com.atlassian.velocity.htmlsafe.util.Check;

/**
 * A velocity method that proxies method calls to another object
 */
final class ProxiedMethod implements VelMethod
{
    private final VelMethod delegateMethod;
    private final Object proxyObject;

    /**
     * @param delegateMethod method to delegate calls to
     * @param proxyObject object to receive the method call
     */
    public ProxiedMethod(VelMethod delegateMethod, Object proxyObject)
    {
        this.delegateMethod = Check.notNull(delegateMethod, "delegateMethod must not be null");
        this.proxyObject = Check.notNull(proxyObject, "proxyObject must not be null");
    }

    public Object invoke(Object o, Object[] params)
            throws Exception
    {
        return delegateMethod.invoke(proxyObject, params);
    }

    public boolean isCacheable()
    {
        return delegateMethod.isCacheable();
    }

    public String getMethodName()
    {
        return delegateMethod.getMethodName();
    }

    public Class getReturnType()
    {
        return delegateMethod.getReturnType();
    }
}
