/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.velocity.htmlsafe.introspection;

import com.atlassian.velocity.htmlsafe.introspection.MethodAnnotator;
import com.atlassian.velocity.htmlsafe.util.Check;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;

public final class MethodAnnotatorChain
implements MethodAnnotator {
    private final MethodAnnotator[] ANNOTATOR_CHAIN;

    public MethodAnnotatorChain(List<MethodAnnotator> annotators) {
        Check.notNull(annotators, "annotators must not be null");
        for (MethodAnnotator annotator : this.ANNOTATOR_CHAIN = annotators.toArray(new MethodAnnotator[annotators.size()])) {
            Check.notNull(annotator, "null annotator provided in the list");
        }
    }

    @Override
    public Collection<Annotation> getAnnotationsForMethod(Method method) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (MethodAnnotator annotator : this.ANNOTATOR_CHAIN) {
            builder.addAll(annotator.getAnnotationsForMethod(method));
        }
        return builder.build();
    }
}

