/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.memcached;

import com.atlassian.marshalling.api.MarshallingException;
import com.atlassian.marshalling.api.MarshallingPair;
import com.atlassian.vcache.ExternalCacheException;
import com.atlassian.vcache.ExternalCacheSettings;
import com.atlassian.vcache.VCacheUtils;
import com.atlassian.vcache.internal.RequestContext;
import com.atlassian.vcache.internal.core.ExternalCacheKeyGenerator;
import com.atlassian.vcache.internal.core.TransactionControl;
import com.atlassian.vcache.internal.core.TransactionControlManager;
import com.atlassian.vcache.internal.core.VCacheCoreUtils;
import com.atlassian.vcache.internal.core.metrics.MetricsRecorder;
import com.atlassian.vcache.internal.core.service.AbstractExternalCacheRequestContext;
import com.atlassian.vcache.internal.core.service.AbstractTransactionalExternalCache;
import com.atlassian.vcache.internal.core.service.VersionedExternalCacheRequestContext;
import com.atlassian.vcache.internal.memcached.MemcachedUtils;
import com.atlassian.vcache.internal.memcached.MemcachedVCacheServiceSettings;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import net.spy.memcached.MemcachedClientIF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MemcachedTransactionalExternalCache<V>
extends AbstractTransactionalExternalCache<V> {
    private static final Logger log = LoggerFactory.getLogger(MemcachedTransactionalExternalCache.class);
    private final Supplier<MemcachedClientIF> clientSupplier;
    private final ExternalCacheKeyGenerator keyGenerator;
    private final MarshallingPair<V> valueMarshalling;
    private final int ttlSeconds;
    private final TransactionControlManager transactionControlManager;

    MemcachedTransactionalExternalCache(MemcachedVCacheServiceSettings serviceSettings, Supplier<RequestContext> contextSupplier, ExternalCacheKeyGenerator keyGenerator, String name, MarshallingPair<V> valueMarshalling, ExternalCacheSettings settings, TransactionControlManager transactionControlManager, MetricsRecorder metricsRecorder) {
        super(name, contextSupplier, metricsRecorder, serviceSettings.getLockTimeout(), serviceSettings.getExternalCacheExceptionListener());
        this.clientSupplier = Objects.requireNonNull(serviceSettings.getClientSupplier());
        this.keyGenerator = Objects.requireNonNull(keyGenerator);
        this.valueMarshalling = Objects.requireNonNull(valueMarshalling);
        this.ttlSeconds = VCacheCoreUtils.roundUpToSeconds((Duration)((Duration)settings.getDefaultTtl().get()));
        this.transactionControlManager = Objects.requireNonNull(transactionControlManager);
    }

    public void transactionSync() {
        log.trace("Cache {}: synchronising operations", (Object)this.name);
        VersionedExternalCacheRequestContext<V> cacheContext = this.ensureCacheContext();
        VCacheUtils.fold((CompletionStage)this.perform(() -> {
            if (cacheContext.hasRemoveAll()) {
                cacheContext.updateCacheVersion(MemcachedUtils.cacheVersionIncrementer(this.clientSupplier));
            }
            this.performKeyedOperations(cacheContext);
            return null;
        }), v -> null, err -> {
            log.warn("Cache {}: an operation failed during transaction sync ({}). Clearing cache to remove stale entries.", (Object)this.name, (Object)err.getMessage());
            try {
                cacheContext.updateCacheVersion(MemcachedUtils.cacheVersionIncrementer(this.clientSupplier));
            }
            catch (RuntimeException e) {
                log.error("Cache {}: failed to clear the cache: {}", (Object)this.name, (Object)e.getMessage());
            }
            return null;
        });
        cacheContext.forgetAll();
    }

    private void performKeyedOperations(VersionedExternalCacheRequestContext<V> cacheContext) {
        HashMap<Future<Boolean>, String> futureToFailureMessageMap = new HashMap<Future<Boolean>, String>();
        boolean[] anOperationFailed = new boolean[1];
        for (Map.Entry entry2 : cacheContext.getKeyedOperations()) {
            String externalKey = cacheContext.externalEntryKeyFor((String)entry2.getKey());
            if (((AbstractExternalCacheRequestContext.DeferredOperation)entry2.getValue()).isRemove()) {
                log.trace("Cache {}: performing remove on entry {}", (Object)this.name, entry2.getKey());
                futureToFailureMessageMap.put(this.clientSupplier.get().delete(externalKey), "remove entry " + (String)entry2.getKey());
                continue;
            }
            log.trace("Cache {}: performing {} on entry {}", new Object[]{this.name, ((AbstractExternalCacheRequestContext.DeferredOperation)entry2.getValue()).getPolicy(), entry2.getKey()});
            try {
                byte[] valueBytes = this.valueMarshalling.getMarshaller().marshallToBytes(Objects.requireNonNull(((AbstractExternalCacheRequestContext.DeferredOperation)entry2.getValue()).getValue()));
                Future<Boolean> putOp = MemcachedUtils.putOperationForPolicy(((AbstractExternalCacheRequestContext.DeferredOperation)entry2.getValue()).getPolicy(), this.clientSupplier.get(), externalKey, MemcachedUtils.expiryTime(this.ttlSeconds), valueBytes);
                futureToFailureMessageMap.put(putOp, "put using policy " + ((AbstractExternalCacheRequestContext.DeferredOperation)entry2.getValue()).getPolicy() + " on entry " + (String)entry2.getKey());
            }
            catch (MarshallingException mex) {
                log.warn("Cache {}: Unable to marshall value to perform put operation on entry {}", new Object[]{this.name, entry2.getKey(), mex});
                anOperationFailed[0] = true;
                break;
            }
        }
        futureToFailureMessageMap.entrySet().forEach(entry -> {
            try {
                if (anOperationFailed[0]) {
                    ((Future)entry.getKey()).cancel(true);
                } else {
                    Boolean outcome = (Boolean)((Future)entry.getKey()).get();
                    if (outcome.booleanValue()) {
                        log.trace("Cache {}: successful deferred operation for {}", (Object)this.name, entry.getValue());
                    } else {
                        anOperationFailed[0] = true;
                        log.warn("Cache {}: failed deferred operation for {}", (Object)this.name, entry.getValue());
                    }
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                if (ex instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                anOperationFailed[0] = true;
                log.error("Cache {}: had failure getting result for deferred operation {}", new Object[]{this.name, entry.getValue(), ex});
            }
        });
        if (anOperationFailed[0]) {
            throw new ExternalCacheException(ExternalCacheException.Reason.TRANSACTION_FAILURE);
        }
    }

    protected VersionedExternalCacheRequestContext<V> ensureCacheContext() {
        RequestContext requestContext = (RequestContext)this.contextSupplier.get();
        this.transactionControlManager.registerTransactionalExternalCache(requestContext, this.name, (TransactionControl)this);
        return (VersionedExternalCacheRequestContext)requestContext.computeIfAbsent((Object)this, () -> {
            log.trace("Cache {}: Setting up a new context", (Object)this.name);
            return new VersionedExternalCacheRequestContext(this.keyGenerator, this.name, () -> ((RequestContext)requestContext).partitionIdentifier(), MemcachedUtils.cacheVersionSupplier(this.clientSupplier), this.lockTimeout);
        });
    }

    protected Logger getLogger() {
        return log;
    }

    protected final ExternalCacheException mapException(Exception ex) {
        return MemcachedUtils.mapException(ex);
    }

    protected final Optional<V> directGet(String externalKey) {
        return VCacheCoreUtils.unmarshall((byte[])((byte[])this.clientSupplier.get().get(externalKey)), this.valueMarshalling);
    }

    protected final Map<String, Optional<V>> directGetBulk(Set<String> externalKeys) {
        return MemcachedUtils.directGetBulk(externalKeys, this.clientSupplier, this.valueMarshalling);
    }
}

