package com.atlassian.vcache.internal.memcached;

import com.atlassian.vcache.CasIdentifier;

import javax.annotation.Nullable;

/**
 * Implementation for Memcached.
 *
 * @since 1.0.0
 */
class MemcachedCasIdentifier implements CasIdentifier {
    private long id;

    MemcachedCasIdentifier(long id) {
        this.id = id;
    }

    long getId() {
        return id;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }

        //noinspection SimplifiableIfStatement
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        return id == ((MemcachedCasIdentifier) o).id;
    }
}
