/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.memcached;

import com.atlassian.vcache.CasIdentifier;
import com.atlassian.vcache.DirectExternalCache;
import com.atlassian.vcache.ExternalCacheException;
import com.atlassian.vcache.ExternalCacheSettings;
import com.atlassian.vcache.IdentifiedValue;
import com.atlassian.vcache.Marshaller;
import com.atlassian.vcache.PutPolicy;
import com.atlassian.vcache.internal.RequestContext;
import com.atlassian.vcache.internal.core.DefaultIdentifiedValue;
import com.atlassian.vcache.internal.core.ExternalCacheKeyGenerator;
import com.atlassian.vcache.internal.core.VCacheCoreUtils;
import com.atlassian.vcache.internal.core.service.AbstractExternalCache;
import com.atlassian.vcache.internal.core.service.VersionedExternalCacheRequestContext;
import com.atlassian.vcache.internal.memcached.MemcachedCasIdentifier;
import com.atlassian.vcache.internal.memcached.MemcachedUtils;
import com.google.common.annotations.VisibleForTesting;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import net.spy.memcached.CASResponse;
import net.spy.memcached.CASValue;
import net.spy.memcached.MemcachedClientIF;
import net.spy.memcached.OperationTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MemcachedDirectExternalCache<V>
extends AbstractExternalCache<V>
implements DirectExternalCache<V> {
    private static final Logger log = LoggerFactory.getLogger(MemcachedDirectExternalCache.class);
    private final Supplier<MemcachedClientIF> clientSupplier;
    private final Supplier<RequestContext> contextSupplier;
    private final ExternalCacheKeyGenerator keyGenerator;
    private final Marshaller<V> valueMarshaller;
    private final int ttlSeconds;

    MemcachedDirectExternalCache(Supplier<MemcachedClientIF> clientSupplier, Supplier<RequestContext> contextSupplier, ExternalCacheKeyGenerator keyGenerator, String name, Marshaller<V> valueMarshaller, ExternalCacheSettings settings) {
        super(name);
        this.clientSupplier = Objects.requireNonNull(clientSupplier);
        this.contextSupplier = Objects.requireNonNull(contextSupplier);
        this.keyGenerator = Objects.requireNonNull(keyGenerator);
        this.valueMarshaller = Objects.requireNonNull(valueMarshaller);
        this.ttlSeconds = VCacheCoreUtils.roundUpToSeconds((Duration)((Duration)settings.getDefaultTtl().get()));
    }

    @Nonnull
    public CompletionStage<Optional<V>> get(String internalKey) {
        return this.perform(() -> {
            String externalKey = this.buildExternalKey(internalKey);
            return VCacheCoreUtils.unmarshall((byte[])((byte[])this.clientSupplier.get().get(externalKey)), this.valueMarshaller);
        });
    }

    @Nonnull
    public CompletionStage<V> get(String internalKey, Supplier<V> supplier) {
        return this.perform(() -> {
            Future addOp;
            String externalKey = this.buildExternalKey(internalKey);
            Optional existingValue = VCacheCoreUtils.unmarshall((byte[])((byte[])this.clientSupplier.get().get(externalKey)), this.valueMarshaller);
            if (existingValue.isPresent()) {
                return existingValue.get();
            }
            log.trace("Cache {}, creating candidate for key {}", (Object)this.name, (Object)internalKey);
            Object candidateValue = Objects.requireNonNull(supplier.get());
            byte[] candidateValueBytes = this.valueMarshaller.marshall(candidateValue);
            while (!((Boolean)(addOp = this.clientSupplier.get().add(externalKey, MemcachedUtils.expiryTime(this.ttlSeconds), (Object)candidateValueBytes)).get()).booleanValue()) {
                log.info("Cache {}, unable to add candidate for key {}, retrieve what was added", (Object)this.name, (Object)internalKey);
                Optional otherAddedValue = VCacheCoreUtils.unmarshall((byte[])((byte[])this.clientSupplier.get().get(externalKey)), this.valueMarshaller);
                if (otherAddedValue.isPresent()) {
                    return otherAddedValue.get();
                }
                log.info("Cache {}, unable to retrieve recently added candidate for key {}, looping", (Object)this.name, (Object)internalKey);
            }
            return candidateValue;
        });
    }

    @Nonnull
    public CompletionStage<Optional<IdentifiedValue<V>>> getIdentified(String internalKey) {
        return this.perform(() -> {
            String externalKey = this.buildExternalKey(internalKey);
            CASValue casValue = this.clientSupplier.get().gets(externalKey);
            if (casValue == null) {
                return Optional.empty();
            }
            MemcachedCasIdentifier identifier = new MemcachedCasIdentifier(casValue.getCas());
            DefaultIdentifiedValue iv = new DefaultIdentifiedValue((CasIdentifier)identifier, this.valueMarshaller.unmarshall((byte[])casValue.getValue()));
            return Optional.of(iv);
        });
    }

    @Nonnull
    public CompletionStage<Map<String, Optional<V>>> getBulk(Iterable<String> internalKeys) {
        return this.perform(() -> {
            if (VCacheCoreUtils.isEmpty((Iterable)internalKeys)) {
                return new HashMap();
            }
            VersionedExternalCacheRequestContext<V> cacheContext = this.ensureCacheContext();
            Set externalKeys = StreamSupport.stream(internalKeys.spliterator(), false).map(arg_0 -> cacheContext.externalEntryKeyFor(arg_0)).collect(Collectors.toSet());
            Map haveValues = this.clientSupplier.get().getBulk(externalKeys);
            return externalKeys.stream().collect(Collectors.toMap(arg_0 -> cacheContext.internalEntryKeyFor(arg_0), k -> VCacheCoreUtils.unmarshall((byte[])((byte[])haveValues.get(k)), this.valueMarshaller)));
        });
    }

    @Nonnull
    public CompletionStage<Map<String, V>> getBulk(Function<Set<String>, Map<String, V>> factory, Iterable<String> internalKeys) {
        return this.perform(() -> {
            if (VCacheCoreUtils.isEmpty((Iterable)internalKeys)) {
                return new HashMap();
            }
            VersionedExternalCacheRequestContext cacheContext = this.ensureCacheContext();
            Set externalKeys = Collections.unmodifiableSet(StreamSupport.stream(internalKeys.spliterator(), false).map(arg_0 -> cacheContext.externalEntryKeyFor(arg_0)).collect(Collectors.toSet()));
            Map haveValues = this.clientSupplier.get().getBulk(externalKeys);
            log.trace("{} of {} entries have values", (Object)haveValues.size(), (Object)externalKeys.size());
            HashSet missingExternalKeys = new HashSet(externalKeys);
            missingExternalKeys.removeAll(haveValues.keySet());
            Map<String, Object> grandResult = haveValues.entrySet().stream().collect(Collectors.toMap(e -> cacheContext.internalEntryKeyFor((String)e.getKey()), e -> VCacheCoreUtils.unmarshall((byte[])((byte[])e.getValue()), this.valueMarshaller).get()));
            if (!missingExternalKeys.isEmpty()) {
                Set missingInternalKeys = Collections.unmodifiableSet(missingExternalKeys.stream().map(arg_0 -> cacheContext.internalEntryKeyFor(arg_0)).collect(Collectors.toSet()));
                Map missingValues = (Map)factory.apply(missingInternalKeys);
                Map<String, Future> internalKeyToFutureMap = missingValues.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.clientSupplier.get().set(cacheContext.externalEntryKeyFor((String)e.getKey()), MemcachedUtils.expiryTime(this.ttlSeconds), (Object)VCacheCoreUtils.marshall(e.getValue(), this.valueMarshaller))));
                for (Map.Entry<String, Future> e2 : internalKeyToFutureMap.entrySet()) {
                    e2.getValue().get();
                }
                grandResult.putAll(missingValues);
            }
            return grandResult;
        });
    }

    @Nonnull
    public CompletionStage<Map<String, Optional<IdentifiedValue<V>>>> getBulkIdentified(Iterable<String> internalKeys) {
        return this.perform(() -> {
            if (VCacheCoreUtils.isEmpty((Iterable)internalKeys)) {
                return new HashMap();
            }
            VersionedExternalCacheRequestContext<V> cacheContext = this.ensureCacheContext();
            Map<String, Future> internalKeyToFuture = StreamSupport.stream(internalKeys.spliterator(), false).distinct().collect(Collectors.toMap(k -> k, k -> this.clientSupplier.get().asyncGets(cacheContext.externalEntryKeyFor(k))));
            return internalKeyToFuture.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> MemcachedUtils.identifiedValueFrom((Future)e.getValue(), this.valueMarshaller)));
        });
    }

    @Nonnull
    public CompletionStage<Boolean> put(String internalKey, V value, PutPolicy policy) {
        return this.perform(() -> {
            String externalKey = this.buildExternalKey(internalKey);
            byte[] valueBytes = this.valueMarshaller.marshall(value);
            Future<Boolean> putOp = MemcachedUtils.putOperationForPolicy(policy, this.clientSupplier.get(), externalKey, MemcachedUtils.expiryTime(this.ttlSeconds), valueBytes);
            return putOp.get();
        });
    }

    @Nonnull
    public CompletionStage<Boolean> removeIf(String internalKey, CasIdentifier casId) {
        return this.perform(() -> {
            String externalKey = this.buildExternalKey(internalKey);
            Future delOp = this.clientSupplier.get().delete(externalKey, MemcachedUtils.safeExtractId(casId));
            return (Boolean)delOp.get();
        });
    }

    @Nonnull
    public CompletionStage<Boolean> replaceIf(String internalKey, CasIdentifier casId, V newValue) {
        return this.perform(() -> {
            String externalKey = this.buildExternalKey(internalKey);
            CASResponse casOp = this.clientSupplier.get().cas(externalKey, MemcachedUtils.safeExtractId(casId), MemcachedUtils.expiryTime(this.ttlSeconds), (Object)this.valueMarshaller.marshall(newValue));
            return casOp == CASResponse.OK;
        });
    }

    @Nonnull
    public CompletionStage<Void> remove(Iterable<String> internalKeys) {
        return this.perform(() -> {
            if (VCacheCoreUtils.isEmpty((Iterable)internalKeys)) {
                return null;
            }
            List deleteOps = StreamSupport.stream(internalKeys.spliterator(), false).map(this::buildExternalKey).map(k -> this.clientSupplier.get().delete(k)).collect(Collectors.toList());
            for (Future delOp : deleteOps) {
                delOp.get();
            }
            return null;
        });
    }

    @Nonnull
    public CompletionStage<Void> removeAll() {
        return this.perform(() -> {
            VersionedExternalCacheRequestContext<V> cacheContext = this.ensureCacheContext();
            cacheContext.updateCacheVersion(MemcachedUtils.incrementCacheVersion(this.clientSupplier, cacheContext.externalCacheVersionKey()));
            return null;
        });
    }

    @VisibleForTesting
    void refreshCacheVersion() {
        VersionedExternalCacheRequestContext<V> cacheContext = this.ensureCacheContext();
        cacheContext.updateCacheVersion(MemcachedUtils.obtainCacheVersion(this.clientSupplier, cacheContext.externalCacheVersionKey()));
    }

    private String buildExternalKey(String internalKey) throws OperationTimeoutException {
        VersionedExternalCacheRequestContext<V> cacheContext = this.ensureCacheContext();
        return cacheContext.externalEntryKeyFor(internalKey);
    }

    @Nonnull
    protected VersionedExternalCacheRequestContext<V> ensureCacheContext() throws OperationTimeoutException {
        RequestContext requestContext = this.contextSupplier.get();
        return (VersionedExternalCacheRequestContext)requestContext.computeIfAbsent((Object)this, () -> {
            log.trace("Cache {}: Setting up a new context", (Object)this.name);
            VersionedExternalCacheRequestContext newCacheContext = new VersionedExternalCacheRequestContext(this.keyGenerator, this.name, () -> ((RequestContext)requestContext).partitionIdentifier());
            newCacheContext.updateCacheVersion(MemcachedUtils.obtainCacheVersion(this.clientSupplier, newCacheContext.externalCacheVersionKey()));
            return newCacheContext;
        });
    }

    @Nonnull
    protected Logger getLogger() {
        return log;
    }

    @Nonnull
    protected ExternalCacheException mapException(Exception ex) {
        return MemcachedUtils.mapException(ex);
    }
}

