/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.memcached;

import com.atlassian.vcache.DirectExternalCache;
import com.atlassian.vcache.ExternalCacheSettings;
import com.atlassian.vcache.JvmCache;
import com.atlassian.vcache.JvmCacheSettings;
import com.atlassian.vcache.Marshaller;
import com.atlassian.vcache.StableReadExternalCache;
import com.atlassian.vcache.TransactionalExternalCache;
import com.atlassian.vcache.internal.BegunTransactionalActivityHandler;
import com.atlassian.vcache.internal.RequestContext;
import com.atlassian.vcache.internal.VCacheCreationHandler;
import com.atlassian.vcache.internal.VCacheSettingsDefaultsProvider;
import com.atlassian.vcache.internal.core.ExternalCacheKeyGenerator;
import com.atlassian.vcache.internal.core.metrics.MetricsCollector;
import com.atlassian.vcache.internal.core.service.AbstractVCacheService;
import com.atlassian.vcache.internal.core.service.GuavaJvmCache;
import com.atlassian.vcache.internal.guava.GuavaDirectExternalCache;
import com.atlassian.vcache.internal.guava.GuavaStableReadExternalCache;
import com.atlassian.vcache.internal.guava.GuavaTransactionalExternalCache;
import com.atlassian.vcache.internal.guava.GuavaUtils;
import com.atlassian.vcache.internal.memcached.MemcachedDirectExternalCache;
import com.atlassian.vcache.internal.memcached.MemcachedStableReadExternalCache;
import com.atlassian.vcache.internal.memcached.MemcachedTransactionalExternalCache;
import com.atlassian.vcache.internal.memcached.MemcachedVCacheServiceSettings;
import com.atlassian.vcache.internal.memcached.MemcachedVCacheServiceSettingsBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.spy.memcached.MemcachedClientIF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemcachedVCacheService
extends AbstractVCacheService {
    private static final Logger log = LoggerFactory.getLogger(MemcachedVCacheService.class);
    private final Supplier<MemcachedClientIF> clientSupplier;
    private final Function<String, Boolean> dontExternaliseCache;

    @Deprecated
    public MemcachedVCacheService(String productIdentifier, Supplier<MemcachedClientIF> clientSupplier, Supplier<RequestContext> contextSupplier, VCacheSettingsDefaultsProvider defaultsProvider, VCacheCreationHandler creationHandler, MetricsCollector metricsCollector, BegunTransactionalActivityHandler begunTransactionalActivityHandler) {
        this(new MemcachedVCacheServiceSettingsBuilder().productIdentifier(productIdentifier).clientSupplier(clientSupplier).defaultsProvider(defaultsProvider).contextSupplier(contextSupplier).creationHandler(creationHandler).metricsCollector(metricsCollector).begunTransactionalActivityHandler(begunTransactionalActivityHandler).build());
    }

    @Deprecated
    public MemcachedVCacheService(Supplier<MemcachedClientIF> clientSupplier, Supplier<RequestContext> contextSupplier, VCacheSettingsDefaultsProvider defaultsProvider, VCacheCreationHandler creationHandler, MetricsCollector metricsCollector, ExternalCacheKeyGenerator externalCacheKeyGenerator, BegunTransactionalActivityHandler begunTransactionalActivityHandler) {
        this(new MemcachedVCacheServiceSettingsBuilder().clientSupplier(clientSupplier).contextSupplier(contextSupplier).defaultsProvider(defaultsProvider).creationHandler(creationHandler).metricsCollector(metricsCollector).externalCacheKeyGenerator(externalCacheKeyGenerator).begunTransactionalActivityHandler(begunTransactionalActivityHandler).build());
    }

    public MemcachedVCacheService(MemcachedVCacheServiceSettings settings) {
        super(settings.getContextSupplier(), settings.getDefaultsProvider(), settings.getCreationHandler(), settings.getMetricsCollector(), settings.getExternalCacheKeyGenerator(), settings.getBegunTransactionalActivityHandler());
        this.clientSupplier = Objects.requireNonNull(settings.getClientSupplier());
        this.dontExternaliseCache = Objects.requireNonNull(settings.getDontExternaliseCache());
    }

    @Nonnull
    protected Logger log() {
        return log;
    }

    @Nonnull
    protected <K, V> JvmCache<K, V> createJvmCache(String name, JvmCacheSettings settings) {
        return new GuavaJvmCache(name, settings);
    }

    @Nonnull
    protected <V> TransactionalExternalCache<V> createTransactionalExternalCache(String name, ExternalCacheSettings settings, Marshaller<V> valueMarshaller, boolean valueSerializable) {
        if (this.dontExternaliseCache.apply(name).booleanValue()) {
            log.trace("Cache {}: not being externalised", (Object)name);
            return new GuavaTransactionalExternalCache(name, GuavaUtils.buildDelegate((ExternalCacheSettings)settings), this.contextSupplier, this.externalCacheKeyGenerator, Optional.of(valueMarshaller), this.transactionControlManager);
        }
        return new MemcachedTransactionalExternalCache<V>(this.clientSupplier, this.contextSupplier, this.externalCacheKeyGenerator, name, valueMarshaller, settings, this.transactionControlManager);
    }

    @Nonnull
    protected <V> StableReadExternalCache<V> createStableReadExternalCache(String name, ExternalCacheSettings settings, Marshaller<V> valueMarshaller, boolean valueSerializable) {
        if (this.dontExternaliseCache.apply(name).booleanValue()) {
            log.trace("Cache {}: not being externalised", (Object)name);
            return new GuavaStableReadExternalCache(name, GuavaUtils.buildDelegate((ExternalCacheSettings)settings), this.contextSupplier, this.externalCacheKeyGenerator, Optional.of(valueMarshaller));
        }
        return new MemcachedStableReadExternalCache<V>(this.clientSupplier, this.contextSupplier, this.externalCacheKeyGenerator, name, valueMarshaller, settings);
    }

    @Nonnull
    protected <V> DirectExternalCache<V> createDirectExternalCache(String name, ExternalCacheSettings settings, Marshaller<V> valueMarshaller, boolean valueSerializable) {
        if (this.dontExternaliseCache.apply(name).booleanValue()) {
            log.trace("Cache {}: not being externalised", (Object)name);
            return new GuavaDirectExternalCache(name, GuavaUtils.buildDelegate((ExternalCacheSettings)settings), this.contextSupplier, this.externalCacheKeyGenerator, Optional.of(valueMarshaller));
        }
        return new MemcachedDirectExternalCache<V>(this.clientSupplier, this.contextSupplier, this.externalCacheKeyGenerator, name, valueMarshaller, settings);
    }
}

