package com.atlassian.vcache.internal.memcached;

import com.atlassian.vcache.internal.BegunTransactionalActivityHandler;
import com.atlassian.vcache.internal.ExternalCacheExceptionListener;
import com.atlassian.vcache.internal.RequestContext;
import com.atlassian.vcache.internal.VCacheCreationHandler;
import com.atlassian.vcache.internal.VCacheSettingsDefaultsProvider;
import com.atlassian.vcache.internal.core.ExternalCacheKeyGenerator;
import com.atlassian.vcache.internal.core.metrics.MetricsCollector;
import net.spy.memcached.MemcachedClientIF;

import java.time.Duration;
import java.util.function.Function;
import java.util.function.Supplier;

import static java.util.Objects.requireNonNull;

/**
 * Represents the settings for a {@link MemcachedVCacheService}.
 * They are created using the {@link MemcachedVCacheServiceSettingsBuilder},
 * which you should consult for the description of each property.
 *
 * @since 1.3.0
 */
public class MemcachedVCacheServiceSettings {
    private final Supplier<MemcachedClientIF> clientSupplier;
    private final Supplier<RequestContext> contextSupplier;
    private final VCacheSettingsDefaultsProvider defaultsProvider;
    private final VCacheCreationHandler creationHandler;
    private final MetricsCollector metricsCollector;
    private final ExternalCacheKeyGenerator externalCacheKeyGenerator;
    private final BegunTransactionalActivityHandler begunTransactionalActivityHandler;
    private final Function<String, Boolean> dontExternaliseCache;
    private final boolean serializationHack;
    private final Duration lockTimeout;
    private Supplier<RequestContext> workContextContextSupplier;
    private final ExternalCacheExceptionListener externalCacheExceptionListener;

    MemcachedVCacheServiceSettings(Supplier<MemcachedClientIF> clientSupplier,
                                   Supplier<RequestContext> contextSupplier,
                                   Supplier<RequestContext> workContextContextSupplier,
                                   VCacheSettingsDefaultsProvider defaultsProvider,
                                   VCacheCreationHandler creationHandler,
                                   MetricsCollector metricsCollector,
                                   ExternalCacheKeyGenerator externalCacheKeyGenerator,
                                   BegunTransactionalActivityHandler begunTransactionalActivityHandler,
                                   Function<String, Boolean> dontExternaliseCache,
                                   boolean serializationHack,
                                   Duration lockTimeout,
                                   ExternalCacheExceptionListener externalCacheExceptionListener) {
        this.clientSupplier = requireNonNull(clientSupplier);
        this.contextSupplier = requireNonNull(contextSupplier);
        this.workContextContextSupplier = requireNonNull(workContextContextSupplier);
        this.defaultsProvider = requireNonNull(defaultsProvider);
        this.creationHandler = requireNonNull(creationHandler);
        this.metricsCollector = requireNonNull(metricsCollector);
        this.externalCacheKeyGenerator = requireNonNull(externalCacheKeyGenerator);
        this.begunTransactionalActivityHandler = requireNonNull(begunTransactionalActivityHandler);
        this.dontExternaliseCache = requireNonNull(dontExternaliseCache);
        this.serializationHack = serializationHack;
        this.lockTimeout = requireNonNull(lockTimeout);
        this.externalCacheExceptionListener = requireNonNull(externalCacheExceptionListener);
    }

    public Supplier<MemcachedClientIF> getClientSupplier() {
        return clientSupplier;
    }

    public Supplier<RequestContext> getContextSupplier() {
        return contextSupplier;
    }

    public VCacheSettingsDefaultsProvider getDefaultsProvider() {
        return defaultsProvider;
    }

    public VCacheCreationHandler getCreationHandler() {
        return creationHandler;
    }

    public MetricsCollector getMetricsCollector() {
        return metricsCollector;
    }

    public ExternalCacheKeyGenerator getExternalCacheKeyGenerator() {
        return externalCacheKeyGenerator;
    }

    public BegunTransactionalActivityHandler getBegunTransactionalActivityHandler() {
        return begunTransactionalActivityHandler;
    }

    public Function<String, Boolean> getDontExternaliseCache() {
        return dontExternaliseCache;
    }

    public Supplier<RequestContext> getWorkContextContextSupplier() {
        return workContextContextSupplier;
    }

    public boolean isSerializationHack() {
        return serializationHack;
    }

    public Duration getLockTimeout() {
        return lockTimeout;
    }

    public ExternalCacheExceptionListener getExternalCacheExceptionListener() {
        return externalCacheExceptionListener;
    }
}
