package com.atlassian.vcache.internal.legacy;

import java.time.Duration;

import static java.util.Objects.requireNonNull;

/**
 * Represents the settings for the legacy service.
 *
 * @since 1.0
 */
public class LegacyServiceSettings {
    private final boolean avoidCasOps;
    private final boolean serializationHack;
    private final Duration lockTimeout;

    LegacyServiceSettings(boolean avoidCasOps, boolean serializationHack, Duration lockTimeout) {
        this.avoidCasOps = avoidCasOps;
        this.serializationHack = serializationHack;
        this.lockTimeout = requireNonNull(lockTimeout);
    }

    public boolean isAvoidCasOps() {
        return avoidCasOps;
    }

    public boolean isSerializationHack() {
        return serializationHack;
    }

    public Duration getLockTimeout() {
        return lockTimeout;
    }
}
