/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.legacy;

import com.atlassian.cache.Cache;
import com.atlassian.vcache.internal.core.service.AbstractLockingJvmCache;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

class LegacyJvmCache<K, V>
extends AbstractLockingJvmCache<K, V> {
    private final Cache<K, V> delegate;

    public LegacyJvmCache(Cache<K, V> delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Nonnull
    protected V decoratedGet(K key, Supplier<? extends V> supplier) {
        return (V)this.delegate.get(key, supplier::get);
    }

    protected void decoratedRemove(K key) {
        this.delegate.remove(key);
    }

    protected void decoratedRemoveAll() {
        this.delegate.removeAll();
    }

    @Nonnull
    public Set<K> getKeys() {
        return new HashSet(this.delegate.getKeys());
    }

    @Nonnull
    public Optional<V> get(K key) {
        return Optional.ofNullable(this.delegate.get(key));
    }

    public void put(K key, V value) {
        this.delegate.put(key, value);
    }

    @Nonnull
    public Optional<V> putIfAbsent(K key, V value) {
        return Optional.ofNullable(this.delegate.putIfAbsent(key, value));
    }

    public boolean replaceIf(K key, V currentValue, V newValue) {
        return this.delegate.replace(key, currentValue, newValue);
    }

    public boolean removeIf(K key, V value) {
        return this.delegate.remove(key, value);
    }

    @Nonnull
    public String getName() {
        return this.delegate.getName();
    }
}

