package com.atlassian.vcache.internal.legacy;

import com.atlassian.cache.Cache;
import com.atlassian.vcache.JvmCache;
import com.atlassian.vcache.internal.core.service.AbstractLockingJvmCache;

import javax.annotation.Nonnull;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

import static java.util.Objects.requireNonNull;

/**
 * Implementation of {@link JvmCache} that backs onto a legacy {@link Cache}.
 *
 * @param <K> the key type
 * @param <V> the value type
 * @since 1.0.0
 */
class LegacyJvmCache<K, V> extends AbstractLockingJvmCache<K, V> {
    private final Cache<K, V> delegate;

    public LegacyJvmCache(Cache<K, V> delegate) {
        this.delegate = requireNonNull(delegate);
    }

    @Nonnull
    @Override
    protected V decoratedGet(K key, Supplier<? extends V> supplier) {
        return delegate.get(key, supplier::get);
    }

    @Override
    protected void decoratedRemove(K key) {
        delegate.remove(key);
    }

    @Override
    protected void decoratedRemoveAll() {
        delegate.removeAll();
    }

    @Nonnull
    @Override
    public Set<K> getKeys() {
        return new HashSet<>(delegate.getKeys());
    }

    @Nonnull
    @Override
    public Optional<V> get(K key) {
        return Optional.ofNullable(delegate.get(key));
    }

    @Override
    public void put(K key, V value) {
        delegate.put(key, value);
    }

    @Nonnull
    @Override
    public Optional<V> putIfAbsent(K key, V value) {
        return Optional.ofNullable(delegate.putIfAbsent(key, value));
    }

    @Override
    public boolean replaceIf(K key, V currentValue, V newValue) {
        return delegate.replace(key, currentValue, newValue);
    }

    @Override
    public boolean removeIf(K key, V value) {
        return delegate.remove(key, value);
    }

    @Nonnull
    @Override
    public String getName() {
        return delegate.getName();
    }

}
