package com.atlassian.vcache.internal;

import com.atlassian.vcache.ExternalCache;
import com.atlassian.vcache.ExternalCacheSettings;
import com.atlassian.vcache.JvmCache;
import com.atlassian.vcache.JvmCacheSettings;

import javax.annotation.Nonnull;

/**
 * A manager for retrieving the default settings for caches.
 *
 * @since 1.0
 */
public interface VCacheSettingsDefaultsProvider {
    /**
     * Obtain the default settings for an {@link ExternalCache}.
     *
     * @param name the cache name
     * @return the default settings for the specified cache
     */
    @Nonnull
    ExternalCacheSettings getExternalDefaults(String name);

    /**
     * Obtain the default settings for a {@link JvmCache}.
     *
     * @param name the cache name
     * @return the default settings for the specified cache
     */
    @Nonnull
    JvmCacheSettings getJvmDefaults(String name);
}
