package com.atlassian.vcache.internal;

/**
 * Specifies the interface for a handler that is called when transactional activity has begun for a request.
 *
 * @since 1.2.0
 */
@FunctionalInterface
public interface BegunTransactionalActivityHandler {
    /**
     * Called for the request that has begun transactional activity. The handler will be called only once for each
     * request.
     * @param context the {@link RequestContext} for the request that has begun transactional activity.
     */
    void onRequest(RequestContext context);
}
