package com.atlassian.vcache.internal;

import com.atlassian.vcache.ExternalCacheException;

/**
 * Called whenever an {@link ExternalCacheException} is being thrown.
 * This is to allow the opportunity to record metrics.
 * Implementations of this interface should not throw an exception.
 *
 * @since 1.12.0
 */
public interface ExternalCacheExceptionListener {

    /**
     * Called when the supplied exception is about to be thrown.
     * @param cacheName the name of the cache associated with the exception
     * @param ex the exception to be thrown
     */
    void onThrow(String cacheName, ExternalCacheException ex);
}
