/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache;

import com.atlassian.annotations.PublicApi;
import com.atlassian.vcache.ChangeRate;
import com.atlassian.vcache.SettingsUtils;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

@PublicApi
public class ExternalCacheSettings {
    private final Optional<Duration> defaultTtl;
    private final Optional<Integer> entryCountHint;
    private final Optional<ChangeRate> dataChangeRateHint;
    private final Optional<ChangeRate> entryGrowthRateHint;

    ExternalCacheSettings(Optional<Duration> defaultTtl, Optional<Integer> entryCountHint, Optional<ChangeRate> dataChangeRateHint, Optional<ChangeRate> entryGrowthRateHint) {
        this.defaultTtl = Objects.requireNonNull(defaultTtl);
        this.entryCountHint = Objects.requireNonNull(entryCountHint);
        this.dataChangeRateHint = Objects.requireNonNull(dataChangeRateHint);
        this.entryGrowthRateHint = Objects.requireNonNull(entryGrowthRateHint);
    }

    @Nonnull
    public ExternalCacheSettings override(ExternalCacheSettings overrides) {
        return new ExternalCacheSettings(SettingsUtils.ifPresent(overrides.getDefaultTtl(), this.getDefaultTtl()), SettingsUtils.ifPresent(overrides.getEntryCountHint(), this.getEntryCountHint()), SettingsUtils.ifPresent(overrides.getDataChangeRateHint(), this.getDataChangeRateHint()), SettingsUtils.ifPresent(overrides.getEntryGrowthRateHint(), this.getEntryGrowthRateHint()));
    }

    @Nonnull
    public Optional<Duration> getDefaultTtl() {
        return this.defaultTtl;
    }

    @Nonnull
    public Optional<Integer> getEntryCountHint() {
        return this.entryCountHint;
    }

    @Nonnull
    public Optional<ChangeRate> getDataChangeRateHint() {
        return this.dataChangeRateHint;
    }

    @Nonnull
    public Optional<ChangeRate> getEntryGrowthRateHint() {
        return this.entryGrowthRateHint;
    }
}

